"""
Program to make any number of balls that are any color bounce around
the screen randomly

Written by Frankie Cerkvenik, inspired by a demo by Chris Peich and Mehran Sahami

"""
import random
import time
import sys

from graphics import Canvas
from bouncyball_soln import BouncyBall


CANVAS_WIDTH = 800
CANVAS_HEIGHT = 500
BALL_SIZE = 15
DELAY = 1/120


def setup_bouncyballs(canvas, num, color):
    balls = []
    for i in range(num):
        x = random.randint(BALL_SIZE, CANVAS_WIDTH - BALL_SIZE)
        y = random.randint(BALL_SIZE, CANVAS_HEIGHT - BALL_SIZE)
        ball = BouncyBall(canvas, color, x, y, BALL_SIZE)
        balls.append(ball)
    return balls

def do_bouncing_balls(canvas, bouncyballs):
    while True:
        for i in range(len(bouncyballs)):
            ball = bouncyballs[i]
            ball.move()
        canvas.update()
        time.sleep(DELAY)
def main():
    args = sys.argv[1:]

    if len(args) != 2:
        print('please run with two arguments, like python3 bouncing_balls_animation.py 10 pink')
        return

    num_balls = int(args[0])
    color = args[1]
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT)
    bouncyballs = setup_bouncyballs(canvas, num_balls, color)
    do_bouncing_balls(canvas, bouncyballs)

if __name__ == '__main__':
    main()