"""Class to represent a ball on a canvas randomly bouncing around

Written by Frankie Cerkvenik, inspired by a demo by Chris Peich and Mehran Sahami
"""
import random

class BouncyBall:
    def __init__(self, canvas, color, x, y, size):
        self.size = size
        self.canvas = canvas
        self.oval = canvas.create_oval(x, y, x + size, y + size, color)
        self.dx = random.choice([-1, 1]) * random.uniform(1, 3)
        self.dy = random.choice([-1, 1]) * random.uniform(1, 3)

    def move(self):
        self.canvas.move(self.oval, self.dx, self.dy)

        oval_coords = self.canvas.coords(self.oval)
        left_x = oval_coords[0]
        top_y = oval_coords[1]
        right_x = oval_coords[2]
        bottom_y = oval_coords[3]

        if top_y <= 0 or bottom_y >= self.canvas.get_height():
            self.dy *= -1
        if left_x <= 0 or right_x >= self.canvas.get_width():
            self.dx *= -1
