import SimpleServer
import json


# We define a class to handle server requests
class ChatServer:
    def __init__(self):
        """
        We need data to 'persist' between requests. In this case, we want to
        store the history of messages we have received.
        """

    # This is the server request callback function. You can't change its header.
    def handle_request(self, request):
        """
        A message has just arrived (from the internet)!  We need to respond!
        """
        print(request)
        return 'command unknown!'

    def new_message(self, params):
        pass

    def get_messages(self, params):
        pass


def main():
    # Make the server handler
    handler = ChatServer()
    # Start the server to handle internet requests at the specified port
    SimpleServer.run_server(handler, 8000)

if __name__ == '__main__':
    main()
