"""
This file contains the solution for the in range problem
"""

def in_range(n, low, high):
    """
    Returns True if n is between low and high, inclusive.
    >>> in_range(5, 1, 10)
    True
    >>> in_range(5, 1, 3)
    False
    >>> in_range(5, 5, 10)
    True
    """
    if low <= n and high >= n:
        return True
    return False


def main():
    n = int(input("Enter a number: ")) # convert inputs to integer
    low_num = int(input("Enter a lower bound: "))
    high_num = int(input("Enter an upper bound: "))
    if low_num > high_num:
        print("Please make sure the first number is lower than the second")
    else:
        in_bounds = in_range(n, low_num, high_num)
        if in_bounds is None:
            print("Please implement in range")
        elif in_bounds:
            print("The number is in range, yay")
        else:
            print("The number is not in range")





if __name__ == "__main__":
    main()