"""
    This file contains a potential solution for the mystery square
    problem on section handout three.

    Curated by Ecy King, CS106A Summer 2023
"""
import random
import time
from graphics import Canvas

CANVAS_WIDTH = 600 # width of the canvas that pops up
CANVAS_HEIGHT = 400 # height of the canvas that pops up
SQUARE_SIZE = 200 # size of our square
DELAY = 1 # number of seconds to delay
COLORS = ['red', 'orange', 'yellow', 'green', 'blue', 'indigo', 'violet',
          'pink', 'purple', 'white', 'grey', 'brown', 'tan', 'black']



def create_square(canvas, color):
    """
    This is the first step in the suggested approach outline:

   " Create a square that's SQUARE_SIZE pixels in width and height
    in the center of the screen. You can choose any initial color."
    """
    start_x = CANVAS_WIDTH / 2 - SQUARE_SIZE / 2  # get the starting x coordinate (left)
    start_y = CANVAS_HEIGHT / 2 - SQUARE_SIZE / 2 # get the starting y coordinate(top)

    # the - 1 is so that the square is exactly square size
    end_x = start_x + SQUARE_SIZE - 1  # get the exact ending x coordinate(right)
    end_y = start_y + SQUARE_SIZE - 1 # get the exact ending y coordinate (bottom)

    # use these coordinates to create the rectangle of color, which is passed in
    square = canvas.create_rectangle(start_x, start_y, end_x, end_y, color=color)
    return square # return the square we have created


def create_animation_loop(canvas, square):
    """
    This is the second  step in the suggested approach outline:

    "Create an animation loop; within a loop, sleep for DELAY seconds
    and then call canvas.update()."
    """
    while True: # create the while true loop
        color = get_random_color() # selects a random color
        canvas.set_color(square, color) # change color
        canvas.update() # update the canvas to be the new color of the square
        time.sleep(DELAY) # wait for DELAY time (NOTE: take this out and things flash super fast!)

def get_random_color():
    """
    This is the third step in the suggested approach outline:

    Select a new color from the list COLORS each time you loop.
     Perhaps this is a good place to employ a helper function,
     perhaps get_random_color() which returns a random color from your list.
    """
    # uses the random.choice function to pick a random color from the list
    return random.choice(COLORS)


def main():
    # creates a canvas of width and height
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Color Changing Square')
    # runs our loop
    sq = create_square(canvas, 'gold')
    create_animation_loop(canvas, sq)


if __name__ == "__main__":
    main()