"""
-----------------
The solution for the Magic Circles Problem
_________________
"""

from graphics import Canvas
import random
import time

CANVAS_WIDTH = 600
CANVAS_HEIGHT = 400
MIN_RADIUS = 20
MAX_RADIUS = 100

COLORS = ['red', 'orange', 'yellow', 'green', 'blue', 'purple', 'brown', '#8c1515']


# draw a circle centered at x and y with given radius and color
def draw_circle(canvas, x_center, y_center, radius, color):
    x_start = x_center - radius
    y_start = y_center - radius
    x_end = x_start + 2*radius  # making coordinates relative to start
    y_end = y_start + 2*radius

    canvas.create_oval(x_start, y_start, x_end, y_end, color=color)


# draws circle centered at x, y
def draw_random_circle(canvas, x, y):
    radius = random.randint(MIN_RADIUS, MAX_RADIUS) # get radius randomly

    # this is a function that gets a random item from list, is but one way to solve
    # has not totally been covered yet, but is one way to do the problem
    color = random.choice(COLORS)

    # draw the circle
    draw_circle(canvas, x, y, radius, color)

def main():
    canvas = Canvas(CANVAS_WIDTH, CANVAS_HEIGHT, 'Magic Circles')

    while True:  # In our loop, wait for a click
        canvas.wait_for_click() # Wait for a click

        # get the x and y coordinates that the mouse is at
        mouse_x = canvas.get_mouse_x()
        mouse_y = canvas.get_mouse_y()

        # draw the random circle
        draw_random_circle(canvas, mouse_x, mouse_y)

        # update the canvas
        canvas.update()


if __name__ == "__main__":
    main()

