
"""
Stanford Rotate Image Left Function Solution

Usage: python3 image_fn.py monkey-300.jpg
"""

import sys
from simpleimage import SimpleImage


def rotate_image_left(filename):
    """
    Given a filename representing an image, open
    the image and return an out image rotated
    90 degrees to the left
    """
    image = SimpleImage(filename)
    out = SimpleImage.blank(image.height, image.width)  # they are swapped
    for y in range(image.height):
        for x in range(image.width):
            pixel = image.get_pixel(x, y)  # get current pix
            # for any x, y in image we want to get y, end coordinate in out
            out_pix = out.get_pixel(y, (image.width - 1) - x)
            # copy it all over
            out_pix.red = pixel.red
            out_pix.green = pixel.green
            out_pix.blue = pixel.blue

    return out



def main():
    args = sys.argv[1:]
    # args:
    # image to rotate
    if len(args) == 1:
        image = rotate_image_left(args[0])
        image.show() #shows the image


if __name__ == '__main__':
    main()
