def is_even(n):
    """
    >>> is_even(0)
    True
    >>> is_even(2)
    True
    >>> is_even(5)
    False
    >>> is_even(1)
    False
    """
    if n % 2 == 0:
        return True
    return False


def is_prime(n):
    """

    >>> is_prime(1)
    False
    >>> is_prime(2)
    True
    >>> is_prime(3)
    True
    >>> is_prime(15)
    False

    """
    if n == 1:  # 1 not prime
        return False
    if n == 2:  # 2 is prime
        return True

    # a little inefficient but gets job done
    for num in range(2, n):
        if n % num == 0:
            return False
    return True


def only_one_even(num1, num2):
    """
    >>> only_one_even(1, 2)
    True
    >>> only_one_even(4, 8)
    False
    >>> only_one_even(3, 9)
    False
    """
    if is_even(num1) and is_even(num2):
        return False
    if is_even(num1) or is_even(num2):
        return True
    return False

def is_power_of_two(n):
    """
    >>> is_power_of_two(1)
    True
    >>> is_power_of_two(2)
    True
    >>> is_power_of_two(6)
    False
    >>> is_power_of_two(64)
    True
    >>> is_power_of_two(28)
    False
    """
    # Keep dividing the number by 2 until it becomes 1 or an odd number
    while n % 2 == 0:
        n //= 2  # can do int div

    # if the final number is 1, we have a power of two
    if n == 1:
        return True
    else:
        return False

