import random

# the skill score needed for an astronaut to pass the first cut
SKILL_SCORE_MINIMUM = 0.90
# combined score is 95 percent skill, feel free to try other numbers
SKILL_WEIGHT = 0.95
# combined score is 5 percent luck, feel free to try other numbers
LUCK_WEIGHT = 0.05


def main():
    # Finish the rest of main()

    print_introduction()

    num_applicants = int(input("How many people want to be astronauts? "))
    applicants = make_applicants(num_applicants)

    skilled_applicants = make_first_cut(applicants)
    print("There are", len(skilled_applicants),
          "wannabe astronauts skillful enough to make the first cut.")

    num_to_select = int(input("How many people get to become astronauts? "))
    selected_astronauts = select_top_astronauts(skilled_applicants,
                                                num_to_select)

    # Find the average luck and skill scores for the skilled applicants
    # and the selected astronauts

    # Calculate the percent increases for luck and skill
    # Use the function find_percent_increase(starting_value, final_value)

    # Call print_conclusion here when you have the necessary info
    # print_conclusion(skill_percent_increase, luck_percent_increase, num_skillful_astronauts)


def make_applicants(num_applicants):
    """
    Returns a list of applicants, where each applicant
    is a list with a random skill and luck score, e.g.
    one_applicant = {'skill': XXXX, 'luck': YYYY}

    Luck and skill scores should be a float between 
    0 and 1, use random.random()
    """
    applicants = []

    # Your code here

    return applicants


def make_first_cut(applicants):
    """
    Returns a new list of skilled applicants, made
    only of applicants with a skill score that is
    greater than or equal to SKILL_SCORE_MINIMUM
    """
    skilled_applicants = []

    # Your code here

    return skilled_applicants


def calc_combined_score(applicant):
    """
    Calculates the combined score of an applicant
    Apply SKILL_WEIGHT and LUCK_WEIGHT to each
    score and return the sum
    """

    # Your code here

    pass


# Add more functions here!


###
#
# No need to edit the code after this point, but feel free to look!
#
###
def print_introduction():
    print(
        "Welcome! This program explores a simplified comparison of luck and skill."
    )
    print(
        "Set the constant PRINT_STAT_DETAILS to True to see additional information."
    )
    print("-------------------------")


def select_top_astronauts(astronauts, num_to_select):
    """
    Returns the top X astronauts, as determined by
    the calc_score function, which incorporates a bit of luck
    """
    # the key=calc_combined_score arranges this list based on the combined score,
    sorted_astronauts = sorted(astronauts, key=calc_combined_score)

    # This gets the last astronauts in the list, AKA the astronauts with the top scores
    selected_astronauts = sorted_astronauts[-num_to_select:]

    return selected_astronauts


def find_percent_increase(starting_value, final_value):
    decimal_increase = (final_value - starting_value) / starting_value
    percent_increase = round(decimal_increase * 100, 1)
    return percent_increase


def print_conclusion(skill_percent_increase, luck_percent_increase,
                     num_skillful_astronauts):
    print("-------------------------")
    print("-------- SUMMARY --------")
    print("The selected group is (on average):")
    print(" -",
          str(skill_percent_increase) + "%", "more skillful than the",
          num_skillful_astronauts, "people that passed the first cut")
    print(" -",
          str(luck_percent_increase) + "%", "luckier than the",
          num_skillful_astronauts, "people that passed the first cut")


# This provided line is required at the end of a Python file
# to call the main() function.
if __name__ == '__main__':
    main()
