#!/usr/bin/env python3

"""
Stanford CS106A Peeps Grid Example
Nick Parlante
"""

import sys

from grid import Grid


"""
Say we have  a 2-d grid, and every square is either 'p'
for a peep, or is None.
"""


def is_happy(grid, x, y):
    """
    Given a grid of peeps and in bounds x,y.
    Return True if there is a peep at that x,y
    and it is happy.
    A peep is happy if there is another peep
    immediately to its left or right.
    >>> grid = Grid.build([[None, 'p', 'p'], ['p', None, 'p']])
    >>> is_happy(grid, 0, 0)
    False
    >>> is_happy(grid, 1, 0)
    True
    >>> is_happy(grid, 2, 0)
    True
    >>> is_happy(grid, 0, 1)
    False
    >>> is_happy(grid, 2, 1)
    False
    """
    # 1. Check if there's a peep at x,y
    # If not we can return False immediately.
    if grid.get(x, y) != 'p':
        return False

    # 2. Happy because of peep to right?
    # Must check that x+1 is in bounds before calling get()
    if grid.in_bounds(x + 1, y):
        if grid.get(x + 1, y) == 'p':
            return True

    # 3. Similarly, is there a peep to the left?
    if grid.in_bounds(x - 1, y):
        if grid.get(x - 1, y) == 'p':
            return True

    # 4. If we get to here, not a happy peep,
    # so return False
    return False


# The has_happy example works on a column, not just one x,y.
# Doctests are provided. Call has_happy() to check each x,y.
# Has a similar return True/False strategy as the has_alpha
# lecture example.
def has_happy(grid, x):
    """
    Given grid of peeps and an in-bounds x.
    Return True if there is a happy peep in
    that column somewhere, or False if there
    is no happy peep.
    >>> grid = Grid.build([[None, 'p', 'p'], ['p', None, 'p']])  # same grid as before
    >>> has_happy(grid, 0)
    False
    >>> has_happy(grid, 1)
    True
    """
    pass
    # x is specified in parameter, loop over all y
    for y in range(grid.height):
        if is_happy(grid, x, y):
            return True
    # if we get here .. no happy peep found
    return False

def main():
    args = sys.argv[1:]
    print('not using main()')


if __name__ == '__main__':
    main()
