#!/usr/bin/env python3

"""
Stanford CS106A Hardware Demo
Nick Parlante
show using CPU and Memory
Observe this program running in Activity Monitor (Mac)
Task Manager (windows)

Command line args:

-cpu 10000    # use cpu, printing every 100000
-mem 100      # use 100 MB per sec
"""

import sys
import time


def use_cpu(n):
    """
    Infinite loop counting a variable 0, 1, 2...
    print a line every n (0 = no printing)
    """
    i = 0
    while True:
        if n != 0 and i % n == 0:
            print(i)
        i = i + 1


# Approximate bytes used per int in a list
# 24 bytes for the int value itself
# 8 bytes for the list slot that points to the int
BYTES_PER_ELEM = 24 + 8


def use_mem(mb_count):
    """
    Add mb_count megabytes of RAM usage every second
    """
    size = 0
    outer = []
    # figure the number of ints to store in RAM to use up mb
    num_bytes = mb_count * 1000000
    num_ints = num_bytes // BYTES_PER_ELEM
    # Run this loop once per second
    while True:
        inner = list(range(num_ints))
        outer.append(inner)
        size += mb_count
        print('Memory MB:', size)
        time.sleep(1.0)


def main():
    args = sys.argv[1:]
    if len(args) >= 1 and args[0] == '-cpu':
        n = 0
        if len(args) == 2:
            n = int(args[1])
        use_cpu(n)

    if len(args) == 2 and args[0] == '-mem':
        mb = 100
        if len(args) == 2:
            mb = int(args[1])
        use_mem(mb)


if __name__ == '__main__':
    main()
