import sys
import matplotlib.pyplot as plt


def read_file(filename):
    """
    (Provided)
    Reads the information from the specified file and builds a new
    years dictionary with the data found in the file. Returns the
    newly created dictionary.
    >>> read_file('data-short.txt')
    {1900: [0, 1], 1940: [0, 2], 2020: [2, 0]}
    """
    years = {}
    with open(filename) as f:
        for line in f:
            line = line.strip()
            parts = line.split(',')

            year = int(parts[2]) // 10 * 10  # round year down to nearest decade
            score = int(parts[1])            # number of Bechdel requirements met

            if year not in years:
                years[year] = [0, 0]         # initialize (pass, fail) counts to 0
            counts_tup = years[year]
            if score == 3:                   # if this movie passes all 3 Bechdel requirements
                counts_tup[0] += 1
            else:
                counts_tup[1] += 1
    return years


def plot_test(years):
    """
    Plots the fraction of movies that pass the Bechdel test over time.
    Years is a nested dictionary where the keys are decades as ints,
    and values are lists where index 0 has the number of tests that
    passed and index 1 has the number of tests that failed.
    """
    x_vals = []  # REPLACE WITH YOUR CODE
    y_vals = []  # REPLACE WITH YOUR CODE

    plt.plot(x_vals, y_vals, color='green')

    plt.title('Number of Movies that Pass the Bechdel Test')
    plt.show()


def main():
    # no need to edit main
    args = sys.argv[1:]
    if len(args) == 1:
        years = read_file(args[0])
        plot_test(years)
    else:
        print('Usage: python3 bechdel-graphs.py [filename]')


if __name__ == '__main__':
    main()