"""
File: 24hour_time.py
---------------------
This program asks the user for a time in
"12-hour time", with the format "11:15PM"
and converts it to "24-hour time". 11:15PM
would be 23:15.
"""

def convert_time(time):
    """
    The input time is formatted as "12 hour" time (e.g. 11:45PM)
    and this function returns the equivalent "24 hour" time (e.g. 23:45).


    Doctests:
        >>> convert_time("11:59PM")
        '23:59'
        >>> convert_time("12:01PM")
        '12:01'
        >>> convert_time("12:15AM")
        '00:15'
        >>> convert_time("01:15AM")
        '01:15'
        >>> convert_time("11:14AM")
        '11:14'
    """

    # Find the start of AM / PM
    suffix_index = len(time) - 2

    # Find the colon character
    colon_index = time.find(":")

    # Slice our the hour and minute portions
    hour = time[:colon_index]
    minute = time[colon_index +  1 : suffix_index]

    # If this is a PM time
    if time[suffix_index] == "P":
        if int(hour) == 12:
            return f"{hour}:{minute}"
        return f"{int(hour) + 12}:{minute}"

    else:
        # This is a morning (AM) time
        if int(hour) == 12:
            return f"00:{minute}"
        return f"{hour}:{minute}"

def main():
    twelve_hour_time = input("What time is it? ")
    twenty_four_hour_time = convert_time(twelve_hour_time)
    print(twenty_four_hour_time)


if __name__ == "__main__":
	main()