"""
File: average_length_word.py
-----------------------------
This program takes in user input and
computes the average length of the 
individual words in the input. Words
are determined as tokens separated 
by spaces. 
"""

def compute_average_word_length(s):
	"""
	Takes in a sentence and finds the average word length.

	>>> compute_average_word_length("")
	0

	>>> compute_average_word_length("hey mom")
	3.0

	>>> compute_average_word_length("CS106A is so awesome")
	4.25
	"""

	words = s.split()
	if len(words) == 0:
		return 0

	total_length = 0
	for word in words:
		total_length += len(word)

	return total_length / len(words) # len(words) is the total number of words in the sentence

def main():
	user_input = input("Enter a sentence: ")
	avg = compute_average_word_length(user_input)
	print(f"The average word length is {avg}")

if __name__ == "__main__":
	main()