"""
File: thermostat.py
-------------------
This file defines the Thermostat class.
Each instance of the Thermostat class represent
the overall temperatures within one building.
One building can have several rooms, and one room
can have several sensors.
"""

class Thermostat:

    def __init__(self):
        """
        Constructor for the Thermostat class.
        """
        self.rooms = {}

    def add_room(self, room_name):
        """
        The add_room method takes in a named room
        and adds that room to self.rooms. We can
        then begin to track the different sensors within
        that room.
        """
        self.rooms[room_name] = {}

    def get_temp(self, room_name, sensor_name):
        """
        The get_temp method takes in a room name and
        a sensor name and returns the temperature in
        that room and at that sensor.

        Expected to return a float. Returns -1.0 in the error case.
        """
        if room_name not in self.rooms:
            print(f"{room_name} has not been added to this Thermostat!!!!")
            return -1.0

        if sensor_name not in self.rooms[room_name]:
            print(f"{sensor_name} does not exist in {room_name}!!!!")
            return -1.0

        return self.rooms[room_name][sensor_name]

    def set_temp(self, room_name, sensor_name, temp):
        """
        The set_temp method takes in a room name, a sensor
        name and a float temperature and sets, within our
        dictionary, the temperature at that sensor, within
        that room, to the given temp.
        """
        self.rooms[room_name][sensor_name] = temp

    def average_sensors(self, room_name):
        """
        The average_sensors method takes in a room name and
        averages all of the float value temperatures for the
        different sensors in that room, and returns the float
        average back to the user.
        """
        total_temp = 0
        sensors = self.rooms[room_name]
        for sensor_name in sensors:
            total_temp += sensors[sensor_name]

        return total_temp / len(self.rooms[room_name])
