import json

START_YEAR = 1800
END_YEAR = 2015
N_YEARS = END_YEAR - START_YEAR + 1

'''
Creates a file mindset.json that stores the data as a giant dictionary.
The dictionary associates years with all data for that year. 

Each year is a dictionary from country name to country data. For example:

{
    "1800":{
        "Afghanistan":{"life":28.21, "pop":3280000, "gdp":603.0},
        "Albania":{"life":28.2, "pop":3284351, "gdp":604.0},
        ...
        "Zimbabwe":{"life":20.8, "pop": 12226542, "gdp":98.0}
    },

    ...
}
'''

def main():
    print('cleaning data...')
    data = {}
    add_data(data, 'life.csv')
    add_data(data, 'pop.csv')
    add_data(data, 'gdp.csv')

    # saves data as json file!
    json.dump(data, open('mindset.json', 'w'), indent=2)

# TODO: implement
def add_data(data, file_name):
    """
    The file_name is of the format <key>.csv where
    key is one of "life", "pop", "gdp"

    Each file is a list of rows formatted like:
    Afghanistan,28.21,28.2,28.1 ...

    Our data dictionary is formatted like this
    {
       1800: {
          "Afghanistan": {"life":28.21,"pop":3280000,"gdp":603.0},
          "Albania": {"life": 20.8,"pop": 12226542,"gdp": 98.0}
          ...
       },
       1801: { ... }
       ...

    }
    """
    key = file_name.split('.')[0]



if __name__ == '__main__':
    main()