#!/usr/bin/env python3

"""
Flex-Arrow Example / Exercise

"""

import sys
from drawcanvas import DrawCanvas


def draw_arrow(canvas, x, y, length, flex_factor):
    """
    Draw a horizontal line with arrow heads at both ends.
    Its left endpoint at x,y, extending for length pixels.
    flex_factor is 0.0 .. 1.0, the fraction of length
    to add/subtract from ends to make the arrow heads.
    """
    # Compute right x endpoint, draw horizontal line
    x_right = x + length - 1
    canvas.draw_line(x, y, x_right, y)

    # Draw left arrowhead, add/subtract flex from x,y
    flex = flex_factor * length
    canvas.draw_line(x, y, x + flex, y - flex)  # up
    canvas.draw_line(x, y, x + flex, y + flex)  # down

    # Draw right arrowhead from the right endpoint
    # your code here
    pass
    canvas.draw_line(x_right, y, x_right - flex, y - flex)  # up
    canvas.draw_line(x_right, y, x_right - flex, y + flex)  # down


def draw_arrows(width, height, flex_factor, trick=False):
    """
    Create a canvas, draw two arrows on it.
    If trick is True, draw the second arrow head flipped.
    """
    canvas = DrawCanvas(width, height)

    # Arrow length is half width
    length = width * 0.5
    # Position it at 25% along width and height
    # (it looks fine without the -1, but we're being precise)
    x = (width - 1) * 0.25
    y = (height - 1) * 0.25
    draw_arrow(canvas, x, y, length, flex_factor)

    # Trick mode: make flex negative
    if trick:
        flex_factor = flex_factor * -1

    y2 = (height - 1) * 0.75
    draw_arrow(canvas, x, y2, length, flex_factor)



def main():
    args = sys.argv[1:]
    # Arg forms:
    # -arrows 0.2
    # -trick 0.2

    # Figure window size (default 500 x 300)
    # Optionally command line can have width height numbers to override
    # e.g. -arrows 0.1 1000 500
    width = 500
    height = 300
    if len(args) == 4:
        width = int(args[-2])
        height = int(args[-1])

    if len(args) >= 2 and args[0] == '-arrows':
        draw_arrows(width, height, float(args[1]))

    if len(args) >= 2 and args[0] == '-trick':
        draw_arrows(width, height, float(args[1]), trick=True)

    DrawCanvas.mainloop()



if __name__ == '__main__':
    main()
