#!/usr/bin/env python3
import sys


def reverse_keys(counts):
    """
    Given a counts dictionary, prints out the keys
    in reverse alphabetical order.
    >>> reverse_keys({'eggs': 3, 'coconut milk': 6, 'croissant': 12})
    eggs
    croissant
    coconut milk
    """
    pass


def most_used(counts):
    """
    Takes in a counts dictionary and prints the 5 keys
    with the highest count along with their count.
    >>> most_used({'eggs': 3, 'coconut milk': 6, 'croissant': 12})
    croissant 12
    coconut milk 6
    eggs 3
    """
    pass


# Below are all the functions from last week's section - no coding needed below this point!

def add_item(groceries, store, item, num):
    """
    Given a groceries dict which may
    already contain some data, update the
    dict to add new data for the given
    store, item, and num of that item.
    >>> groceries = {} # initialize empty dict
    >>> add_item(groceries, 'safeway', 'eggs', 1) # new store, new item
    {'safeway': {'eggs': 1}}
    >>> add_item(groceries, 'costco', 'croissant', 12) # new store, new item
    {'safeway': {'eggs': 1}, 'costco': {'croissant': 12}}
    >>> add_item(groceries, 'safeway', 'eggs', 2) # seen store, seen item
    {'safeway': {'eggs': 3}, 'costco': {'croissant': 12}}
    >>> add_item(groceries, 'safeway', 'coconut milk', 3) # seen store, new item
    {'safeway': {'eggs': 3, 'coconut milk': 3}, 'costco': {'croissant': 12}}
    """
    if store not in groceries:
        groceries[store] = {}

    inner = groceries[store]
    if item not in inner:
        inner[item] = 0
    inner[item] += num
    '''
    can also do:
    if item not in inner:
        inner[item] = num
    else:
        inner[item] += num
    '''

    return groceries


def make_groceries(filename):
    """
    Given a grocery list file, where each
    line is in the format 'store:item,num'
    create and return the groceries dict
    made from this list.
    Hint: Use your helper function!
    >>> make_groceries('short-list.txt')
    {'safeway': {'eggs': 3, 'coconut milk': 3}, 'costco': {'croissant': 12}}
    """
    groceries = {}
    with open(filename) as f:
        for line in f:
            line = line.strip()
            colon = line.find(':')
            comma = line.find(',')
            store = line[:colon]
            item = line[colon + 1:comma]
            num = int(line[comma + 1:])
            add_item(groceries, store, item, num)
    return groceries


def print_groceries(groceries):
    """
    (provided)
    Prints contents of groceries dict.
    """
    for store in groceries:
        items = groceries[store]
        for item in items:
            count = items[item]
            print('You need ' + str(count) + ' ' + item + '(s) from ' + store)


def flat_counts(groceries):
    """
    (provided)
    Turns a nested dictionary into a
    'flattened' one from item to count.
    """
    flat = {}
    for store in groceries:
        inner = groceries[store]
        for food in inner:
            if food not in flat:
                flat[food] = 0
            flat[food] += inner[food]
    return flat


def main():
    args = sys.argv[1:]
    # to run from terminal:
    # python3 groceries_revisited.py filename      # prints out all groceries
    if len(args) == 1:
        groceries = make_groceries(args[0])
        print_groceries(groceries)

    # python3 groceries_revisited.py -most filename
    if len(args) == 2 and args[0] == '-most':
        groceries = make_groceries(args[1])
        counts = flat_counts(groceries)
        most_used(counts)

    # python3 groceries_revisited.py -reverse filename
    if len(args) == 2 and args[0] == '-reverse':
        groceries = make_groceries(args[1])
        counts = flat_counts(groceries)
        reverse_keys(counts)


if __name__ == '__main__':
    main()