#!/usr/bin/env python3
import sys
from drawcanvas import DrawCanvas


def draw_v(canvas, left, top, width, height):
    """
    Given a canvas and left,right and width,height.
    Draw the "v" figure with that location and size.
    [This code is complete]
    """
    # Draw outer rectangle
    canvas.draw_rect(left, top, width, height, color='blue')

    # Mid is halfway across, 1/3 way down
    mid_x = left + 0.5 * (width - 1)
    mid_y = top + (1 / 3) * (height - 1)
    # Draw lines from upper-left to mid, mid to upper-right
    canvas.draw_line(left, top, mid_x, mid_y, color='red')
    canvas.draw_line(mid_x, mid_y, left + width - 1, top, color='red')


def draw_horn(canvas, left, top, width, height, n):
    """
    Given a canvas and left,right and width,height
    and n. Draw the horn figure with that location
    and size, with n lines.
    """
    # Draw outer rectangle
    canvas.draw_rect(left, top, width, height, color='blue')
    pass


def draw_diagonal(width, height, n):
    """
    Creates a canvas of the given size.
    Draw the diagonal figure of n horn patches.
    """
    pass


def main():
    # Standard first line of main to get args
    args = sys.argv[1:]

    # The command-line parsing here is not a good example
    # of command line parsing - more complex than usual

    # Do this one first - does not use width/height command line

    width = 900
    height = 400
    # Parse width/height/n from command line, giving a helpful
    # error message if it fails.
    if len(args) > 1:
        try:
            width = int(args[1])
            height = int(args[2])
        except Exception:
            print("Error parsing int width/height from command line:" + ' '.join(args))
            return

    # Tricky: we do all the drawing in a try, so that if it takes an exception,
    # we can still do the mainloop() at the end. If we do not do this, an exception
    # causes no graphics output to appear which makes debugging hard.
    try:
        if args[0] == '-v':
            # width/height is whole window, patches are half that size
            canvas = DrawCanvas(width, height, fast_draw=True, title='V')
            patch_width = width / 2
            patch_height = height / 2
            draw_v(canvas, 0, 0, patch_width, patch_height)
            # 2nd patch is shifted over by patch_width, patch_height
            draw_v(canvas, patch_width, patch_height, patch_width, patch_height)

        if args[0] == '-horn':
            n = int(args[3])
            canvas = DrawCanvas(width, height, fast_draw=True, title='Horn')
            patch_width = width / 2
            patch_height = height / 2
            draw_horn(canvas, 0, 0, patch_width, patch_height, n)
            # 2nd patch is shifted over by patch_width, patch_height
            draw_horn(canvas, patch_width, patch_height, patch_width, patch_height, n)

        if args[0] == '-diagonal':
            n = int(args[3])
            draw_diagonal(width, height, n)

    # Print out exception from draw
    except Exception as e:
        print(e)

    DrawCanvas.mainloop()


if __name__ == '__main__':
    main()
