#!/usr/bin/env python3

"""
Stanford CS106AP final exam review problem
Sonja Johnson-Yu
"""


def make_board(positions, size):
    """
    Given a dictionary that uses (row, col) tuples as keys
    and 0 or 1 as values to indicate whether or not a ship
    is at that location and an int indicating the grid’s
    width/height, return a list of lists containing ‘o’ and
    ‘x’ that represents a Battleship grid.

    Input:
        positions (dict[tuple -> int]): coordinate dict
        size (int): height and width of game board

    Returns:
        board (list[list[str]]): list/str representation of board
    """
    board = []
    for row in range(size):
        board_row = []
        for col in range(size):
            val = positions[(row, col)]
            if val == 0:
                board_row.append('o')
            else:
                board_row.append('x')
        board.append(board_row)
    return board


def main():
    positions = {(0,0): 0, (0, 1): 0, (0, 2): 1, (1,0): 0,
                 (1, 1): 0, (1, 2): 1, (2,0): 0, (2, 1): 0, (2, 2): 0}

    print(make_board(positions, 3))


if __name__ == '__main__':
    main()