#!/usr/bin/env python3

"""
Stanford CS106AP final exam review problem
Kylie Jue
"""

class FurnitureCatalog:

    def __init__(self, filename):
        self.catalog = {}
        with open(filename, 'r') as f:
            for line in f:
                line = line.split()
                item = line[0].lower()
                price = float(line[1])
                if item in self.catalog:
                    self.catalog[item].append(price)
                else:
                    self.catalog[item] = [price]

    def get_price_options(self, item):
        if item.lower() in self.catalog:
            return self.catalog[item.lower()]

    def get_must_buys(self):
        must_buys = []
        for item in self.catalog:
            if len(self.catalog[item]) == 1:
                must_buys.append(item)
        return must_buys

    def add_item(self, item, price):
        item = item.lower()
        if item in self.catalog:
            self.catalog[item].append(price)
        else:
            self.catalog[item] = [price]

def main():
    test_catalog = FurnitureCatalog('furniture_options.txt')
    print('Bed prices:')
    print(test_catalog.get_price_options('BED'))
    print('Table prices:')
    print(test_catalog.get_price_options('table'))
    print('Must-buys:')
    print(test_catalog.get_must_buys())
    test_catalog.add_item('pilloW', 4.5)
    print('Must-buys:')
    print(test_catalog.get_must_buys())
    test_catalog.add_item('PILLOW', 2.34)
    print('Pillow prices:')
    print(test_catalog.get_price_options('pIllOw'))
    print('Full catalog:')
    print(test_catalog.catalog)


if __name__ == '__main__':
    main()
