#!/usr/bin/env python3

"""
Stanford CS106AP final exam review problem
Sonja Johnson-Yu
"""


def get_prefix_dict(words):
    """
    Given a list of words, produce a count dictionary,
    where the keys in the dictionary are all of the prefixes
    contained in the list of words, and each value is a list
    of full-length words that start with the given prefix.
    Note: "sonja" is considered a prefix of "sonja", but ""
    is not considered a prefix of "sonja"

    Input:
        words (list[str]): list of words to add to dict

    Returns:
        prefix_dict (dict[str -> list[str]])
    """
    prefix_dict = {}
    for word in words:
        for i in range(1, len(word) + 1):
            prefix = word[:i]
            if prefix not in prefix_dict:
                prefix_dict[prefix] = []
            prefix_dict[prefix].append(word)

    return prefix_dict


def main():
    words = ['sonja', 'son', 'sun']

    print(get_prefix_dict(words))


if __name__ == '__main__':
    main()