from campy.graphics.gobjects import GOval
from campy.graphics.gwindow import GWindow 
from campy.gui.events.mouse import onmouseclicked
import random

NUM_ROCKS = 8
ROCK_DIAMETER = 80
ROCK_SPACING = 20
COLORS = ('RED', 'GREEN', 'YELLOW', 'BLUE', 'BLACK', 'GRAY')

class SpaceRocksGraphics:
	def __init__(self, width, height):
		self.window = GWindow(width, height, title="Space Rocks!")
		self.last_selection = None
		self.rocks = []

		self.add_rocks()
		onmouseclicked(self.handle_mouse_click)

	def add_rocks(self):
		rock_x = 0
		for i in range(NUM_ROCKS):
			rock = GOval(ROCK_DIAMETER, ROCK_DIAMETER)
			rock.filled = True
			rock.fill_color = random.choice(COLORS)
			self.window.add(rock, x=rock_x, y=0)
			rock_x += ROCK_DIAMETER + ROCK_SPACING
			self.rocks.append(rock)

	def reposition_rocks(self):
		x = 0
		for rock in self.rocks:
			rock.x = x
			rock.y = 0
			x += ROCK_DIAMETER + ROCK_SPACING

	def handle_mouse_click(self, event):
		current_selection = self.window.get_object_at(event.x, event.y)

		if self.last_selection == None:
			self.last_selection = current_selection
		else:
			# If this click is the same as the last, remove the rock
			if self.last_selection == current_selection:
				self.rocks.remove(current_selection)
				self.window.remove(current_selection)
				self.last_selection = None
			else:
				# This click is different from the last, so swap rocks
				last_selection_index = -1
				current_selection_index = -1
				# Find the location of both selections in the list
				for i in range(len(self.rocks)):
					if self.rocks[i] == self.last_selection:
						last_selection_index = i
					if self.rocks[i] == current_selection:
						current_selection_index = i
				# Swap the two rocks once they have been found
				self.rocks[last_selection_index], self.rocks[current_selection_index] = self.rocks[current_selection_index], self.rocks[last_selection_index]
				self.last_selection = None
			self.reposition_rocks()

if __name__ == '__main__':
	space_rocks = SpaceRocksGraphics(width=800, height=80)