/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.vorbis.sampled.convert;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.spi.PropertiesContainer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;

public class DecodedVorbisAudioInputStream
extends TAsynchronousFilteredAudioInputStream
implements PropertiesContainer {
    private InputStream oggBitStream_ = null;
    private SyncState oggSyncState_ = null;
    private StreamState oggStreamState_ = null;
    private Page oggPage_ = null;
    private Packet oggPacket_ = null;
    private Info vorbisInfo = null;
    private Comment vorbisComment = null;
    private DspState vorbisDspState = null;
    private Block vorbisBlock = null;
    static final int playState_NeedHeaders = 0;
    static final int playState_ReadData = 1;
    static final int playState_WriteData = 2;
    static final int playState_Done = 3;
    static final int playState_BufferFull = 4;
    static final int playState_Corrupt = -1;
    private int playState;
    private int bufferMultiple_ = 4;
    private int bufferSize_ = this.bufferMultiple_ * 256 * 2;
    private int convsize = this.bufferSize_ * 2;
    private byte[] convbuffer = new byte[this.convsize];
    private byte[] buffer = null;
    private int bytes = 0;
    private float[][][] _pcmf = null;
    private int[] _index = null;
    private int index = 0;
    private int i = 0;
    int bout = 0;
    private HashMap properties = null;
    private long currentBytes = 0L;

    public DecodedVorbisAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        super(audioFormat, -1L);
        this.oggBitStream_ = audioInputStream;
        this.init_jorbis();
        this.index = 0;
        this.playState = 0;
        this.properties = new HashMap();
    }

    private void init_jorbis() {
        this.oggSyncState_ = new SyncState();
        this.oggStreamState_ = new StreamState();
        this.oggPage_ = new Page();
        this.oggPacket_ = new Packet();
        this.vorbisInfo = new Info();
        this.vorbisComment = new Comment();
        this.vorbisDspState = new DspState();
        this.vorbisBlock = new Block(this.vorbisDspState);
        this.buffer = null;
        this.bytes = 0;
        this.currentBytes = 0L;
        this.oggSyncState_.init();
    }

    public Map properties() {
        this.properties.put("ogg.position.byte", new Long(this.currentBytes));
        return this.properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        if (TDebug.TraceAudioConverter) {
            switch (this.playState) {
                case 0: {
                    TDebug.out("playState = playState_NeedHeaders");
                    break;
                }
                case 1: {
                    TDebug.out("playState = playState_ReadData");
                    break;
                }
                case 2: {
                    TDebug.out("playState = playState_WriteData");
                    break;
                }
                case 3: {
                    TDebug.out("playState = playState_Done");
                    break;
                }
                case 4: {
                    TDebug.out("playState = playState_BufferFull");
                    break;
                }
                case -1: {
                    TDebug.out("playState = playState_Corrupt");
                }
            }
        }
        switch (this.playState) {
            case 0: {
                try {
                    this.readHeaders();
                }
                catch (IOException iOException) {
                    this.playState = -1;
                    return;
                }
                this.playState = 1;
                return;
            }
            case 1: {
                this.index = this.oggSyncState_.buffer(this.bufferSize_);
                this.buffer = this.oggSyncState_.data;
                this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("More data : " + this.bytes);
                }
                if (this.bytes == -1) {
                    this.playState = 3;
                    if (!TDebug.TraceAudioConverter) return;
                    TDebug.out("Ogg Stream empty. Settings playState to playState_Done.");
                    return;
                }
                this.oggSyncState_.wrote(this.bytes);
                if (this.bytes == 0) {
                    if (this.oggPage_.eos() != 0 || this.oggStreamState_.e_o_s != 0 || this.oggPacket_.e_o_s != 0) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("oggSyncState wrote 0 bytes: settings playState to playState_Done.");
                        }
                        this.playState = 3;
                    }
                    if (!TDebug.TraceAudioConverter) return;
                    TDebug.out("oggSyncState wrote 0 bytes: but stream not yet empty.");
                    return;
                }
                int n = this.oggSyncState_.pageout(this.oggPage_);
                if (n == 0) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("Setting playState to playState_ReadData.");
                    }
                    this.playState = 1;
                    return;
                }
                if (n == -1) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out("Corrupt or missing data in bitstream; setting playState to playState_ReadData");
                    }
                    this.playState = 1;
                    return;
                }
                this.oggStreamState_.pagein(this.oggPage_);
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("Setting playState to playState_WriteData.");
                }
                this.playState = 2;
                return;
            }
            case 2: {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("Decoding");
                }
                while (true) {
                    int n;
                    if ((n = this.oggStreamState_.packetout(this.oggPacket_)) == 0) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("Packetout returned 0, going to read state.");
                        }
                        break;
                    }
                    if (n == -1) {
                        if (!TDebug.TraceAudioConverter) continue;
                        TDebug.out("Corrupt or missing data in packetout bitstream; going to read state...");
                        continue;
                    }
                    if (this.vorbisBlock.synthesis(this.oggPacket_) != 0) {
                        if (!TDebug.TraceAudioConverter) continue;
                        TDebug.out("VorbisBlock.synthesis() returned !0, continuing.");
                        continue;
                    }
                    this.vorbisDspState.synthesis_blockin(this.vorbisBlock);
                    this.outputSamples();
                    if (this.playState == 4) return;
                }
                this.playState = 1;
                if (this.oggPage_.eos() == 0) return;
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("Settings playState to playState_Done.");
                }
                this.playState = 3;
                return;
            }
            case 4: {
                this.continueFromBufferFull();
                return;
            }
            case -1: {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("Corrupt Song.");
                }
            }
            case 3: {
                this.oggStreamState_.clear();
                this.vorbisBlock.clear();
                this.vorbisDspState.clear();
                this.vorbisInfo.clear();
                this.oggSyncState_.clear();
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("Done Song.");
                }
                try {
                    if (this.oggBitStream_ != null) {
                        this.oggBitStream_.close();
                    }
                    this.getCircularBuffer().close();
                    return;
                }
                catch (Exception exception) {
                    if (!TDebug.TraceAudioConverter) return;
                    TDebug.out(exception.getMessage());
                }
            }
        }
    }

    private void outputSamples() {
        int n;
        while ((n = this.vorbisDspState.synthesis_pcmout(this._pcmf, this._index)) > 0) {
            float[][] fArray = this._pcmf[0];
            this.bout = n < this.convsize ? n : this.convsize;
            double d = 0.0;
            this.i = 0;
            while (this.i < this.vorbisInfo.channels) {
                int n2 = this.i * 2;
                int n3 = this._index[this.i];
                for (int i = 0; i < this.bout; ++i) {
                    d = (double)fArray[this.i][n3 + i] * 32767.0;
                    int n4 = (int)d;
                    if (n4 > Short.MAX_VALUE) {
                        n4 = Short.MAX_VALUE;
                    }
                    if (n4 < Short.MIN_VALUE) {
                        n4 = Short.MIN_VALUE;
                    }
                    if (n4 < 0) {
                        n4 |= 0x8000;
                    }
                    this.convbuffer[n2] = (byte)n4;
                    this.convbuffer[n2 + 1] = (byte)(n4 >>> 8);
                    n2 += 2 * this.vorbisInfo.channels;
                }
                ++this.i;
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("about to write: " + 2 * this.vorbisInfo.channels * this.bout);
            }
            if (this.getCircularBuffer().availableWrite() < 2 * this.vorbisInfo.channels * this.bout) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("Too much data in this data packet, better return, let the channel drain, and try again...");
                }
                this.playState = 4;
                return;
            }
            this.getCircularBuffer().write(this.convbuffer, 0, 2 * this.vorbisInfo.channels * this.bout);
            if (this.bytes < this.bufferSize_ && TDebug.TraceAudioConverter) {
                TDebug.out("Finished with final buffer of music?");
            }
            if (this.vorbisDspState.synthesis_read(this.bout) == 0 || !TDebug.TraceAudioConverter) continue;
            TDebug.out("VorbisDspState.synthesis_read returned -1.");
        }
        this.playState = 1;
    }

    private void continueFromBufferFull() {
        if (this.getCircularBuffer().availableWrite() < 2 * this.vorbisInfo.channels * this.bout) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Too much data in this data packet, better return, let the channel drain, and try again...");
            }
            return;
        }
        this.getCircularBuffer().write(this.convbuffer, 0, 2 * this.vorbisInfo.channels * this.bout);
        this.outputSamples();
    }

    private void readHeaders() throws IOException {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("readHeaders(");
        }
        this.index = this.oggSyncState_.buffer(this.bufferSize_);
        this.buffer = this.oggSyncState_.data;
        this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
        if (this.bytes == -1) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Cannot get any data from selected Ogg bitstream.");
            }
            throw new IOException("Cannot get any data from selected Ogg bitstream.");
        }
        this.oggSyncState_.wrote(this.bytes);
        if (this.oggSyncState_.pageout(this.oggPage_) != 1) {
            if (this.bytes < this.bufferSize_) {
                throw new IOException("EOF");
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Input does not appear to be an Ogg bitstream.");
            }
            throw new IOException("Input does not appear to be an Ogg bitstream.");
        }
        this.oggStreamState_.init(this.oggPage_.serialno());
        this.vorbisInfo.init();
        this.vorbisComment.init();
        if (this.oggStreamState_.pagein(this.oggPage_) < 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Error reading first page of Ogg bitstream data.");
            }
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        if (this.oggStreamState_.packetout(this.oggPacket_) != 1) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Error reading initial header packet.");
            }
            throw new IOException("Error reading initial header packet.");
        }
        if (this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_) < 0) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("This Ogg bitstream does not contain Vorbis audio data.");
            }
            throw new IOException("This Ogg bitstream does not contain Vorbis audio data.");
        }
        this.i = 0;
        while (this.i < 2) {
            int n;
            while (this.i < 2 && (n = this.oggSyncState_.pageout(this.oggPage_)) != 0) {
                if (n != 1) continue;
                this.oggStreamState_.pagein(this.oggPage_);
                while (this.i < 2 && (n = this.oggStreamState_.packetout(this.oggPacket_)) != 0) {
                    if (n == -1) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("Corrupt secondary header.  Exiting.");
                        }
                        throw new IOException("Corrupt secondary header.  Exiting.");
                    }
                    this.vorbisInfo.synthesis_headerin(this.vorbisComment, this.oggPacket_);
                    ++this.i;
                }
            }
            this.index = this.oggSyncState_.buffer(this.bufferSize_);
            this.buffer = this.oggSyncState_.data;
            this.bytes = this.readFromStream(this.buffer, this.index, this.bufferSize_);
            if (this.bytes == -1) break;
            if (this.bytes == 0 && this.i < 2) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("End of file before finding all Vorbis headers!");
                }
                throw new IOException("End of file before finding all Vorbis  headers!");
            }
            this.oggSyncState_.wrote(this.bytes);
        }
        byte[][] byArray = this.vorbisComment.user_comments;
        String string = "";
        for (int i = 0; i < byArray.length && byArray[i] != null; ++i) {
            string = new String(byArray[i], 0, byArray[i].length - 1).trim();
            if (!TDebug.TraceAudioConverter) continue;
            TDebug.out("Comment: " + string);
        }
        this.convsize = this.bufferSize_ / this.vorbisInfo.channels;
        this.vorbisDspState.synthesis_init(this.vorbisInfo);
        this.vorbisBlock.init(this.vorbisDspState);
        this._pcmf = new float[1][][];
        this._index = new int[this.vorbisInfo.channels];
    }

    private int readFromStream(byte[] byArray, int n, int n2) {
        int n3 = 0;
        try {
            n3 = this.oggBitStream_.read(byArray, n, n2);
        }
        catch (Exception exception) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("Cannot Read Selected Song");
            }
            n3 = -1;
        }
        this.currentBytes += (long)n3;
        return n3;
    }

    public void close() throws IOException {
        super.close();
        this.oggBitStream_.close();
    }
}

