/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import stanford.karel.KarelErrorDialog;

class KarelErrorCanvas
extends JPanel {
    private JLabel errorLabel;
    private JTextArea stackTraceArea;

    public KarelErrorCanvas(KarelErrorDialog dialog) {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(false);
        this.errorLabel = new JLabel("");
        Font oldFont = this.errorLabel.getFont();
        this.errorLabel.setFont(oldFont.deriveFont(1, oldFont.getSize() + 2));
        this.errorLabel.addKeyListener(dialog);
        this.stackTraceArea = new JTextArea(8, 50);
        this.stackTraceArea.setFont(new Font("Monospaced", 0, 13));
        this.stackTraceArea.setBorder(null);
        this.stackTraceArea.setEditable(false);
        this.stackTraceArea.setBackground(KarelErrorDialog.DIALOG_BGCOLOR);
        this.stackTraceArea.addKeyListener(dialog);
        this.add((Component)this.errorLabel, "North");
        JScrollPane scroll = new JScrollPane(this.stackTraceArea);
        scroll.setBorder(null);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(20);
        this.add((Component)scroll, "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width + 5, this.getPreferredSize().height + 20));
    }

    public void setText(String msg) {
        this.errorLabel.setText("Error: " + msg);
    }

    public void setStackTrace(String stackTrace) {
        String[] lines = stackTrace.split("\n");
        String stackTraceOut = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.contains("at stanford.") && !line.contains("at acm.")) {
                line = line.replaceAll("\\([A-Za-z0-9_$]+.java:([0-9]+)\\)", "(), line $1");
                if (!(line = line.replaceAll("[ \t]+at ", "")).contains("Exception: ")) {
                    stackTraceOut = String.valueOf(stackTraceOut) + line + "\n";
                }
            }
            ++n2;
        }
        if (!stackTraceOut.isEmpty()) {
            stackTraceOut = stackTraceOut.trim();
        }
        this.stackTraceArea.setText(stackTraceOut);
    }
}

