/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.util.JTFTools;
import acm.util.MediaTools;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class GLabel
extends GObject {
    public static final Font DEFAULT_FONT = new Font("Default", 0, 12);
    private String label;
    private Font labelFont;
    private static final Component DUMMY_COMPONENT = MediaTools.getImageObserver();
    static final long serialVersionUID = 21L;

    public GLabel(String s) {
        this(s, 0.0, 0.0);
    }

    public GLabel(String s, double d, double d1) {
        this.label = s;
        this.setFont(DEFAULT_FONT);
        this.setLocation(d, d1);
    }

    public void setFont(Font font) {
        this.labelFont = JTFTools.getStandardFont(font);
        this.repaint();
    }

    public void setFont(String s) {
        this.setFont(JTFTools.decodeFont(s, this.getFont()));
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setLabel(String s) {
        this.label = s;
        this.repaint();
    }

    public void setText(String s) {
        this.setLabel(s);
    }

    public String getLabel() {
        return this.label;
    }

    public String getText() {
        return this.getLabel();
    }

    protected void paint2d(Graphics2D graphics2d) {
        graphics2d.setFont(this.labelFont);
        graphics2d.drawString(this.label, 0, 0);
    }

    public double getAscent() {
        return this.getFontMetrics().getAscent();
    }

    public double getDescent() {
        return this.getFontMetrics().getDescent();
    }

    public FontMetrics getFontMetrics() {
        Component component = this.getComponent();
        if (component == null) {
            component = DUMMY_COMPONENT;
        }
        return component.getFontMetrics(this.labelFont);
    }

    public GRectangle getBounds() {
        FontMetrics fontmetrics = this.getFontMetrics();
        Shape obj = new Rectangle2D.Double(0.0, -fontmetrics.getAscent(), fontmetrics.stringWidth(this.label), fontmetrics.getHeight());
        AffineTransform affinetransform = this.getMatrix();
        if (affinetransform != null) {
            obj = affinetransform.createTransformedShape(obj);
        }
        Rectangle rectangle = ((Shape)obj).getBounds();
        return new GRectangle(this.getX() + rectangle.getX(), this.getY() + rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public boolean contains(double d, double d1) {
        FontMetrics fontmetrics = this.getFontMetrics();
        Shape obj = new Rectangle2D.Double(0.0, -fontmetrics.getAscent(), fontmetrics.stringWidth(this.label), fontmetrics.getHeight());
        AffineTransform affinetransform = this.getMatrix();
        if (affinetransform != null) {
            obj = affinetransform.createTransformedShape(obj);
        }
        return ((Shape)obj).contains(d - this.getX(), d1 - this.getY());
    }

    public String paramString() {
        return super.paramString() + ", string=\"" + this.label + "\"";
    }
}

