/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.net;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Downloader {
    private Downloader() {
    }

    public static String downloadFile(URL url) throws IOException {
        int numRead;
        String fileName = new File(url.getFile()).getName();
        PrintStream output = new PrintStream(fileName);
        BufferedInputStream input = new BufferedInputStream(url.openStream());
        byte[] buffer = new byte[512000];
        while ((numRead = ((InputStream)input).read(buffer)) != -1) {
            ((OutputStream)output).write(buffer, 0, numRead);
        }
        ((OutputStream)output).close();
        return fileName;
    }

    public static Map<String, byte[]> getZipFileContents(URL url) throws IOException {
        String fileName = Downloader.downloadFile(url);
        ZipFile zip = new ZipFile(fileName);
        TreeMap<String, byte[]> zipFilesMap = new TreeMap<String, byte[]>();
        Enumeration<? extends ZipEntry> enu = zip.entries();
        while (enu.hasMoreElements()) {
            int size;
            ZipEntry ze = enu.nextElement();
            if (ze.isDirectory() || (size = (int)ze.getSize()) < 0) continue;
            InputStream input = zip.getInputStream(ze);
            byte[] b = new byte[size];
            int offset = 0;
            while (size - offset > 0) {
                int bytesRead = input.read(b, offset, size - offset);
                if (bytesRead < 0) break;
                offset += bytesRead;
            }
            zipFilesMap.put(ze.getName(), b);
        }
        zip.close();
        return zipFilesMap;
    }
}

