/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import java.util.HashSet;
import java.util.Set;

public class Lexicon {
    private Set<String> words = new HashSet<String>();
    private Set<String> knownPrefixes = new HashSet<String>();

    public Lexicon() {
        this.knownPrefixes.add("");
        char c = 'A';
        while (c <= 'Z') {
            this.knownPrefixes.add(String.valueOf(c));
            c = (char)(c + '\u0001');
        }
    }

    public void add(String word) {
        word = word.toUpperCase();
        this.words.add(word);
        int i = 2;
        while (i <= word.length()) {
            this.knownPrefixes.add(word.substring(0, i));
            ++i;
        }
    }

    public boolean contains(String word) {
        return this.words.contains(word.toUpperCase());
    }

    public boolean containsPrefix(String prefix) {
        return this.knownPrefixes.contains(prefix.toUpperCase());
    }

    public int size() {
        return this.words.size();
    }

    public int prefixCount() {
        return this.knownPrefixes.size();
    }
}

