/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.gui.TableLayout;
import acm.program.Program;
import acm.util.JTFTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

class ProgressBarDialog
extends JDialog
implements ActionListener {
    private static final int DIALOG_WIDTH = 250;
    private static final int DIALOG_HEIGHT = 90;
    private static final int PROGRESS_BAR_HEIGHT = 25;
    private JProgressBar progressBar;

    public ProgressBarDialog(Program program) {
        super(JTFTools.getEnclosingFrame(program), "Progress", false);
        Container container = this.getContentPane();
        container.setLayout(new TableLayout(2, 1));
        this.progressBar = new JProgressBar();
        container.add((Component)this.progressBar, "weightx=1 left=5 right=5 height=25");
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        container.add((Component)jButton, "top=10 fill=NONE");
        Rectangle rectangle = program.getBounds();
        int n = rectangle.x + (rectangle.width - 250) / 2;
        int n2 = rectangle.y + (rectangle.height - 90) / 2;
        this.setBounds(n, n2, 250, 90);
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.progressBar.setString("Cancel");
        this.setVisible(false);
    }

    public static boolean hasBeenCancelled(JProgressBar jProgressBar) {
        if (jProgressBar == null) {
            return false;
        }
        String string = jProgressBar.getString();
        return string != null && string.equals("Cancel");
    }

    public static void popup(JProgressBar jProgressBar) {
        for (Container container = jProgressBar; container != null; container = container.getParent()) {
            if (!(container instanceof ProgressBarDialog)) continue;
            container.setVisible(true);
            container.repaint();
            return;
        }
    }

    public static void dismiss(JProgressBar jProgressBar) {
        for (Container container = jProgressBar; container != null; container = container.getParent()) {
            if (!(container instanceof ProgressBarDialog)) continue;
            ((Component)container).setVisible(false);
            return;
        }
    }
}

