/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import stanford.cs106.diff.DiffCollection;
import stanford.cs106.util.ExceptionUtils;
import stanford.cs106.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diff {
    public static final String NO_DIFFS_MESSAGE = "No differences found";
    public static final int IGNORE_LEADING = 1;
    public static final int IGNORE_TRAILING = 2;
    public static final int IGNORE_WHITESPACE = 4;
    public static final int IGNORE_BLANK_LINES = 8;
    public static final int IGNORE_CASE = 16;
    public static final int IGNORE_NUMBERS = 32;
    public static final int IGNORE_NONNUMBERS = 64;
    public static final int IGNORE_PUNCTUATION = 128;
    public static final int IGNORE_AFTERDECIMAL = 256;
    public static final int IGNORE_CHARORDER = 512;
    public static final int IGNORE_LINEORDER = 1024;
    public static final int IGNORE_EVERYTHING = 0x100000;
    public static final int FLAGS_DEFAULT = 0;
    public static final int FLAGS_DEFAULT_LENIENT = 30;
    public static final int FLAGS_DEFAULT_STRICT = 10;

    public static List<Difference> diffAsList(String s1, String s2) {
        return Diff.diffAsList(s1, s2, 0);
    }

    public static List<Difference> diffAsList(String s1, String s2, int flags) {
        Iterator iterator;
        s1 = String.valueOf(s1);
        s2 = String.valueOf(s2);
        Object[] lines1 = s1.split("\r?\n");
        Object[] lines2 = s2.split("\r?\n");
        if ((flags & 0x20) != 0) {
            s1 = s1.replaceAll("[0-9]+", "###");
            s2 = s2.replaceAll("[0-9]+", "###");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x40) != 0) {
            s1 = s1.replaceAll("[^0-9\n]+", " ");
            s2 = s2.replaceAll("[^0-9\n]+", " ");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x80) != 0) {
            String punct = "[.,?!'\"()\\/#$%@^&*_\\[\\]{}|<>:;-]+";
            s1 = s1.replaceAll(punct, "");
            s2 = s2.replaceAll(punct, "");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x100) != 0) {
            s1 = s1.replaceAll("\\.[0-9]+", ".#");
            s2 = s2.replaceAll("\\.[0-9]+", ".#");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x10) != 0) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x200) != 0) {
            ArrayList<Object> lines1Sorted = new ArrayList<Object>();
            Object[] objectArray = lines1;
            int n = lines1.length;
            int n2 = 0;
            while (n2 < n) {
                Object line = objectArray[n2];
                line = StringUtils.sortChars((String)line);
                lines1Sorted.add(line);
                ++n2;
            }
            lines1 = lines1Sorted.toArray(new String[0]);
            s1 = StringUtils.join((String[])lines1, "\n");
            ArrayList<Object> lines2Sorted = new ArrayList<Object>();
            Object[] objectArray2 = lines2;
            int n3 = lines2.length;
            n = 0;
            while (n < n3) {
                Object line = objectArray2[n];
                line = StringUtils.sortChars((String)line);
                lines2Sorted.add(line);
                ++n;
            }
            lines2 = lines2Sorted.toArray(new String[0]);
            s2 = StringUtils.join((String[])lines2, "\n");
        }
        if ((flags & 0x400) != 0) {
            Arrays.sort(lines1);
            Arrays.sort(lines2);
            s1 = StringUtils.join((String[])lines1, "\n");
            s2 = StringUtils.join((String[])lines2, "\n");
        }
        if ((flags & 4) != 0) {
            int i = 0;
            while (i < lines1.length) {
                lines1[i] = StringUtils.removeWhitespace((String)lines1[i]);
                ++i;
            }
            i = 0;
            while (i < lines2.length) {
                lines2[i] = StringUtils.removeWhitespace((String)lines2[i]);
                ++i;
            }
        }
        ArrayList<Difference> out = new ArrayList<Difference>();
        if (StringUtils.trimR(s1).equals(StringUtils.trimR(s2))) {
            return out;
        }
        TreeMap reverse1 = new TreeMap();
        TreeMap reverse2 = new TreeMap();
        int i = 0;
        while (i < lines1.length) {
            Object line = lines1[i];
            if (((String)line).length() > 0) {
                if (!reverse1.containsKey(line)) {
                    reverse1.put(line, new TreeSet());
                }
                ((Set)reverse1.get(line)).add(i);
            }
            ++i;
        }
        i = 0;
        while (i < lines2.length) {
            Object line = lines2[i];
            if (((String)line).length() > 0) {
                if (!reverse2.containsKey(line)) {
                    reverse2.put(line, new TreeSet());
                }
                ((Set)reverse2.get(line)).add(i);
            }
            ++i;
        }
        int index1 = 0;
        int index2 = 0;
        ArrayList<Integer> actions = new ArrayList<Integer>();
        while (index1 < lines1.length && index2 < lines2.length) {
            if (((String)lines1[index1]).equals(lines2[index2])) {
                actions.add(4);
                ++index1;
                ++index2;
                continue;
            }
            int best1 = lines1.length;
            int best2 = lines2.length;
            int sub1 = index1;
            int sub2 = index2;
            while (sub1 + sub2 - index1 - index2 < best1 + best2 - index1 - index2) {
                int lineNumber;
                int d = -1;
                if (lines2.length > sub2 && reverse1.containsKey(lines2[sub2])) {
                    iterator = ((Set)reverse1.get(lines2[sub2])).iterator();
                    while (iterator.hasNext()) {
                        lineNumber = (Integer)iterator.next();
                        if (lineNumber < sub1) continue;
                        d = lineNumber;
                        break;
                    }
                }
                if (d >= sub1 && d + sub2 - index1 - index2 < best1 + best2 - index1 - index2) {
                    best1 = d;
                    best2 = sub2;
                }
                d = -1;
                if (lines1.length > sub1 && reverse2.containsKey(lines1[sub1])) {
                    iterator = ((Set)reverse2.get(lines1[sub1])).iterator();
                    while (iterator.hasNext()) {
                        lineNumber = (Integer)iterator.next();
                        if (lineNumber < sub2) continue;
                        d = lineNumber;
                        break;
                    }
                }
                if (d >= sub2 && d + sub1 - index1 - index2 < best1 + best2 - index1 - index2) {
                    best1 = sub1;
                    best2 = d;
                }
                ++sub1;
                ++sub2;
            }
            while (index1 < best1) {
                actions.add(1);
                ++index1;
            }
            while (index2 < best2) {
                actions.add(2);
                ++index2;
            }
        }
        while (index1 < lines1.length) {
            actions.add(1);
            ++index1;
        }
        if ((flags & 2) != 0) {
            while (index2 < lines2.length) {
                actions.add(2);
                ++index2;
            }
        }
        actions.add(8);
        int op = 0;
        int x0 = 0;
        int x1 = 0;
        int y0 = 0;
        int y1 = 0;
        iterator = actions.iterator();
        while (iterator.hasNext()) {
            int action = (Integer)iterator.next();
            if (action == 1) {
                op |= action;
                ++x1;
                continue;
            }
            if (action == 2) {
                op |= action;
                ++y1;
                continue;
            }
            if (op > 0) {
                if (op == 1) {
                    out.add(new Difference(Difference.Type.DELETE, x0, x1 - 1, y0, y1 - 1));
                } else if (op == 3) {
                    out.add(new Difference(Difference.Type.MODIFY, x0, x1 - 1, y0, y1 - 1));
                }
                while (x0 < x1) {
                    out.add(new Difference(Difference.Type.DELETE, x0, x1 - 1, y0, y1 - 1));
                    ++x0;
                }
                if (op == 2 && ((flags & 1) == 0 || x1 > 0)) {
                    out.add(new Difference(Difference.Type.ADD, x0, x1 - 1, y0, y1 - 1));
                }
                while (y0 < y1) {
                    if ((flags & 1) == 0 || op != 2 || x1 > 0) {
                        out.add(new Difference(Difference.Type.ADD, x0, x1 - 1, y0, y1 - 1));
                    }
                    ++y0;
                }
            }
            x0 = ++x1;
            y0 = ++y1;
            op = 0;
        }
        return out;
    }

    public static String diff(String s1, String s2) {
        return Diff.diff(s1, s2, 0);
    }

    public static String diff(String s1, String s2, int flags) {
        s1 = String.valueOf(s1);
        s2 = String.valueOf(s2);
        Object[] lines1 = s1.split("\r?\n");
        Object[] lines2 = s2.split("\r?\n");
        String[] lines1Original = Arrays.copyOf(lines1, lines1.length);
        String[] lines2Original = Arrays.copyOf(lines2, lines2.length);
        if ((flags & 0x20) != 0) {
            s1 = s1.replaceAll("[0-9]+", "###");
            s2 = s2.replaceAll("[0-9]+", "###");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x40) != 0) {
            s1 = s1.replaceAll("[^0-9\n]+", " ");
            s2 = s2.replaceAll("[^0-9\n]+", " ");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x80) != 0) {
            String punct = "[.,?!'\"()\\/#$%@^&*_\\[\\]{}|<>:;-]+";
            s1 = s1.replaceAll(punct, "");
            s2 = s2.replaceAll(punct, "");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x100) != 0) {
            s1 = s1.replaceAll("\\.[0-9]+", ".#");
            s2 = s2.replaceAll("\\.[0-9]+", ".#");
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x10) != 0) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
            lines1 = s1.split("\r?\n");
            lines2 = s2.split("\r?\n");
        }
        if ((flags & 0x200) != 0) {
            ArrayList<Object> lines1Sorted = new ArrayList<Object>();
            Object[] objectArray = lines1;
            int n = lines1.length;
            int n2 = 0;
            while (n2 < n) {
                Object line = objectArray[n2];
                line = StringUtils.sortChars((String)line);
                lines1Sorted.add(line);
                ++n2;
            }
            lines1 = lines1Sorted.toArray(new String[0]);
            s1 = StringUtils.join((String[])lines1, "\n");
            ArrayList<Object> lines2Sorted = new ArrayList<Object>();
            Object[] objectArray2 = lines2;
            int n3 = lines2.length;
            n = 0;
            while (n < n3) {
                Object line = objectArray2[n];
                line = StringUtils.sortChars((String)line);
                lines2Sorted.add(line);
                ++n;
            }
            lines2 = lines2Sorted.toArray(new String[0]);
            s2 = StringUtils.join((String[])lines2, "\n");
        }
        if ((flags & 0x400) != 0) {
            Arrays.sort(lines1);
            Arrays.sort(lines2);
            s1 = StringUtils.join((String[])lines1, "\n");
            s2 = StringUtils.join((String[])lines2, "\n");
        }
        if ((flags & 4) != 0) {
            int i = 0;
            while (i < lines1.length) {
                lines1[i] = StringUtils.removeWhitespace((String)lines1[i]);
                ++i;
            }
            i = 0;
            while (i < lines2.length) {
                lines2[i] = StringUtils.removeWhitespace((String)lines2[i]);
                ++i;
            }
        }
        if (StringUtils.trimR(s1).equals(StringUtils.trimR(s2))) {
            return NO_DIFFS_MESSAGE;
        }
        TreeMap reverse1 = new TreeMap();
        TreeMap reverse2 = new TreeMap();
        int i = 0;
        while (i < lines1.length) {
            Object line = lines1[i];
            if (((String)line).length() > 0) {
                if (!reverse1.containsKey(line)) {
                    reverse1.put(line, new TreeSet());
                }
                ((Set)reverse1.get(line)).add(i);
            }
            ++i;
        }
        i = 0;
        while (i < lines2.length) {
            Object line = lines2[i];
            if (((String)line).length() > 0) {
                if (!reverse2.containsKey(line)) {
                    reverse2.put(line, new TreeSet());
                }
                ((Set)reverse2.get(line)).add(i);
            }
            ++i;
        }
        int index1 = 0;
        int index2 = 0;
        ArrayList<Integer> actions = new ArrayList<Integer>();
        while (index1 < lines1.length && index2 < lines2.length) {
            if (((String)lines1[index1]).equals(lines2[index2])) {
                actions.add(4);
                ++index1;
                ++index2;
                continue;
            }
            int best1 = lines1.length;
            int best2 = lines2.length;
            int sub1 = index1;
            int sub2 = index2;
            while (sub1 + sub2 - index1 - index2 < best1 + best2 - index1 - index2) {
                int lineNumber;
                Iterator iterator;
                int d = -1;
                if (lines2.length > sub2 && reverse1.containsKey(lines2[sub2])) {
                    iterator = ((Set)reverse1.get(lines2[sub2])).iterator();
                    while (iterator.hasNext()) {
                        lineNumber = (Integer)iterator.next();
                        if (lineNumber < sub1) continue;
                        d = lineNumber;
                        break;
                    }
                }
                if (d >= sub1 && d + sub2 - index1 - index2 < best1 + best2 - index1 - index2) {
                    best1 = d;
                    best2 = sub2;
                }
                d = -1;
                if (lines1.length > sub1 && reverse2.containsKey(lines1[sub1])) {
                    iterator = ((Set)reverse2.get(lines1[sub1])).iterator();
                    while (iterator.hasNext()) {
                        lineNumber = (Integer)iterator.next();
                        if (lineNumber < sub2) continue;
                        d = lineNumber;
                        break;
                    }
                }
                if (d >= sub2 && d + sub1 - index1 - index2 < best1 + best2 - index1 - index2) {
                    best1 = sub1;
                    best2 = d;
                }
                ++sub1;
                ++sub2;
            }
            while (index1 < best1) {
                actions.add(1);
                ++index1;
            }
            while (index2 < best2) {
                actions.add(2);
                ++index2;
            }
        }
        while (index1 < lines1.length) {
            actions.add(1);
            ++index1;
        }
        if ((flags & 2) != 0) {
            while (index2 < lines2.length) {
                actions.add(2);
                ++index2;
            }
        }
        actions.add(8);
        int op = 0;
        int x0 = 0;
        int x1 = 0;
        int y0 = 0;
        int y1 = 0;
        ArrayList<String> out = new ArrayList<String>();
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            int action = (Integer)iterator.next();
            if (action == 1) {
                op |= action;
                ++x1;
                continue;
            }
            if (action == 2) {
                op |= action;
                ++y1;
                continue;
            }
            if (op > 0) {
                boolean multipleLines = x1 != x0 + 1;
                String xstr = "" + (multipleLines ? String.valueOf(x0 + 1) + "-" + x1 : Integer.valueOf(x1));
                String ystr = "" + (y1 != y0 + 1 ? String.valueOf(y0 + 1) + "-" + y1 : Integer.valueOf(y1));
                String linesStr = "\nLine" + (multipleLines ? "s " : " ");
                String doStr = "do" + (multipleLines ? "" : "es");
                if (op == 1) {
                    out.add(String.valueOf(linesStr) + xstr + " deleted near student line " + y1);
                } else if (op == 3) {
                    if (xstr.equals(ystr)) {
                        out.add(String.valueOf(linesStr) + xstr + " " + doStr + " not match");
                    } else {
                        out.add(String.valueOf(linesStr) + xstr + " changed to student line " + ystr);
                    }
                }
                while (x0 < x1) {
                    out.add("EXPECTED < " + lines1Original[x0]);
                    ++x0;
                }
                if (op == 2 && ((flags & 1) == 0 || x1 > 0)) {
                    out.add(String.valueOf(linesStr) + " added near student line " + ystr);
                }
                while (y0 < y1) {
                    if ((flags & 1) == 0 || op != 2 || x1 > 0) {
                        out.add("STUDENT  > " + lines2Original[y0]);
                    }
                    ++y0;
                }
            }
            x0 = ++x1;
            y0 = ++y1;
            op = 0;
        }
        if (out.size() > 0) {
            out.add("");
            return StringUtils.join(out, "\n").trim();
        }
        return NO_DIFFS_MESSAGE;
    }

    public static String diffSideBySide(String str1, String str2) {
        return Diff.diffSideBySide(str1, str2, StringUtils.getWidth(str1));
    }

    public static String diffSideBySide(String str1, String str2, int width) {
        str1 = String.valueOf(str1);
        str2 = String.valueOf(str2);
        StringBuilder output = new StringBuilder();
        try {
            Object[] cparts = str1.split("\r?\n");
            Object[] sparts = str2.split("\r?\n");
            DiffCollection differ = new DiffCollection(cparts, sparts);
            for (DiffCollection.Difference diff : differ.diff()) {
                int delStart = diff.getDeletedStart();
                int delEnd = diff.getDeletedEnd();
                int addStart = diff.getAddedStart();
                int addEnd = diff.getAddedEnd();
                String from = diff.deletedIndexToString();
                String to = diff.addedIndexToString();
                String type = delEnd != -1 && addEnd != -1 ? " changed " : (delEnd == -1 ? " added " : " deleted ");
                output.append(String.valueOf(from) + type + to + '\n');
                int deli = delStart;
                int addi = addStart;
                while (deli <= delEnd || addi <= addEnd) {
                    output.append(String.format("%-" + width + "s\t|\t%s\n", deli <= delEnd ? cparts[deli] : "", addi <= addEnd ? sparts[addi] : ""));
                    ++deli;
                    ++addi;
                }
            }
            return output.toString();
        }
        catch (Exception e) {
            return "Exception thrown: " + ExceptionUtils.stackTraceToString(e);
        }
        catch (Error e2) {
            return "Error thrown: " + e2;
        }
    }

    public static class Difference {
        public Type type;
        public int expectedStart;
        public int expectedEnd;
        public int actualStart;
        public int actualEnd;

        public Difference(Type type, int expectedStart, int expectedEnd, int actualStart, int actualEnd) {
            this.type = type;
            this.expectedStart = expectedStart;
            this.expectedEnd = expectedEnd;
            this.actualStart = actualStart;
            this.actualEnd = actualEnd;
        }

        private String rangeHelper(int start, int end) {
            String result = "";
            if (start >= 0) {
                result = String.valueOf(result) + start;
            }
            if (end > start) {
                result = String.valueOf(result) + (result.isEmpty() ? "" : "-") + end;
            }
            return result;
        }

        public String expectedToString() {
            return this.rangeHelper(this.expectedStart, this.expectedEnd);
        }

        public String actualToString() {
            return this.rangeHelper(this.actualStart, this.actualEnd);
        }

        public String toString() {
            return "type=" + (Object)((Object)this.type) + " exp=" + this.expectedToString() + " act=" + this.actualToString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            DELETE,
            ADD,
            MODIFY;

        }
    }
}

