/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.SpeedBarListener;
import java.applet.Applet;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JScrollBar;
import javax.swing.JSlider;

public class Animator
extends Thread {
    public static final int INITIAL = 0;
    public static final int RUNNING = 1;
    public static final int STEPPING = 2;
    public static final int CALLING = 3;
    public static final int STOPPING = 4;
    public static final int STOPPED = 5;
    public static final int FINISHED = 6;
    public static final int TERMINATING = 7;
    private static final double SLOW_DELAY = 1000.0;
    private static final double CLIP_DELAY = 200.0;
    private static final double FAST_DELAY = 0.0;
    private static HashMap<Applet, ArrayList<Thread>> animatorTable = new HashMap();
    private int animatorState = 0;
    private int currentDepth = 0;
    private int callDepth = 0;
    private int delayCount = 0;
    private double animatorSpeed = 0.5;
    private Component speedBar;
    private boolean resumed;

    public Animator() {
        this.initAnimator();
    }

    public Animator(ThreadGroup threadGroup) {
        super(threadGroup, (Runnable)null);
        this.initAnimator();
    }

    public Animator(Runnable runnable) {
        super(runnable);
        this.initAnimator();
    }

    public Animator(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
        this.initAnimator();
    }

    public int getAnimatorState() {
        return this.animatorState;
    }

    public void pause(double d) {
        if (this.animatorState == 7) {
            this.terminate();
        }
        JTFTools.pause(d);
    }

    public void startAction() {
        this.start(1);
    }

    public void stopAction() {
        switch (this.animatorState) {
            case 1: 
            case 2: 
            case 3: {
                this.animatorState = 4;
                break;
            }
        }
    }

    public void stepAction() {
        this.start(2);
    }

    public void callAction() {
        this.callDepth = this.currentDepth;
        this.start(3);
    }

    public boolean buttonAction(String string) {
        if (string.equals("Start")) {
            this.startAction();
        } else if (string.equals("Stop")) {
            this.stopAction();
        } else if (string.equals("Step")) {
            this.stepAction();
        } else if (string.equals("Call")) {
            this.callAction();
        } else {
            return false;
        }
        return true;
    }

    public void setSpeed(double d) {
        this.animatorSpeed = d;
        if (this.speedBar instanceof JSlider) {
            JSlider jSlider = (JSlider)this.speedBar;
            int n = jSlider.getMinimum();
            int n2 = jSlider.getMaximum();
            jSlider.setValue((int)Math.round((double)n + d * (double)(n2 - n)));
        } else if (this.speedBar instanceof JScrollBar) {
            JScrollBar jScrollBar = (JScrollBar)this.speedBar;
            int n = jScrollBar.getMinimum();
            int n3 = jScrollBar.getMaximum();
            jScrollBar.setValue((int)Math.round((double)n + d * (double)(n3 - n)));
        }
    }

    public double getSpeed() {
        return this.animatorSpeed;
    }

    public void trace() {
        this.trace(0);
    }

    public void trace(int n) {
        if (Thread.currentThread() != this) {
            throw new ErrorException("trace() can be called only by the animator thread itself");
        }
        this.currentDepth = n;
        switch (this.animatorState) {
            case 1: {
                this.delay();
                break;
            }
            case 2: 
            case 4: {
                this.breakpoint();
                break;
            }
            case 3: {
                if (this.callDepth < this.currentDepth) {
                    this.delay();
                    break;
                }
                this.breakpoint();
                break;
            }
            case 7: {
                this.terminate();
            }
        }
    }

    public void breakpoint() {
        if (Thread.currentThread() != this) {
            throw new ErrorException("breakpoint() can be called only by the animator thread itself");
        }
        this.animatorState = 5;
        this.breakHook();
        this.suspendAnimator();
    }

    public void delay() {
        boolean bl = true;
        double d = 0.0;
        if (this.animatorSpeed < 0.25) {
            d = 1000.0 + this.animatorSpeed / 0.25 * -800.0;
        } else if (this.animatorSpeed < 0.9) {
            d = 200.0 + Math.sqrt((this.animatorSpeed - 0.25) / 0.65) * -200.0;
        } else {
            switch ((int)(this.animatorSpeed * 99.99 - 90.0)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl = this.delayCount % 10 != 0;
                    break;
                }
                case 2: {
                    bl = this.delayCount % 7 != 0;
                    break;
                }
                case 3: {
                    bl = this.delayCount % 5 != 0;
                    break;
                }
                case 4: {
                    bl = this.delayCount % 3 != 0;
                    break;
                }
                case 5: {
                    bl = this.delayCount % 2 == 0;
                    break;
                }
                case 6: {
                    bl = this.delayCount % 3 == 0;
                    break;
                }
                case 7: {
                    bl = this.delayCount % 4 == 0;
                    break;
                }
                case 8: {
                    bl = this.delayCount % 6 == 0;
                    break;
                }
                case 9: {
                    bl = false;
                }
            }
            this.delayCount = (this.delayCount + 1) % 420;
        }
        if (bl) {
            this.delayHook();
            JTFTools.pause(d);
        }
    }

    public void registerSpeedBar(JSlider jSlider) {
        SpeedBarListener.register(this, jSlider);
        this.speedBar = jSlider;
    }

    public void registerSpeedBar(JScrollBar jScrollBar) {
        SpeedBarListener.register(this, jScrollBar);
        this.speedBar = jScrollBar;
    }

    public Component getSpeedBar() {
        return this.speedBar;
    }

    public void requestTermination() {
        this.animatorState = 7;
    }

    public void checkForTermination() {
        if (this.animatorState == 7) {
            this.terminate();
        } else {
            Animator.yield();
        }
    }

    public static void shutdown(Applet applet) {
        try {
            Class<?> clazz = Class.forName("java.lang.Thread");
            Method method = clazz.getMethod("stop", new Class[0]);
            Object[] objectArray = new Object[]{};
            ArrayList<Thread> arrayList = animatorTable.get(applet);
            if (arrayList != null) {
                animatorTable.remove(applet);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Thread thread = arrayList.get(i);
                    method.invoke((Object)thread, objectArray);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void delayHook() {
    }

    protected void breakHook() {
    }

    protected void resumeHook() {
    }

    protected void controllerHook() {
    }

    public void start() {
        this.start(1);
    }

    private void initAnimator() {
        Applet applet = JTFTools.getApplet();
        if (applet != null) {
            JTFTools.registerApplet(applet, this);
            ArrayList<Thread> arrayList = animatorTable.get(applet);
            if (arrayList == null) {
                arrayList = new ArrayList();
                animatorTable.put(applet, arrayList);
            }
            arrayList.add(this);
        }
    }

    private void start(int n) {
        switch (this.animatorState) {
            case 0: 
            case 6: {
                this.animatorState = n;
                this.resumeHook();
                this.controllerHook();
                super.start();
                break;
            }
            case 5: {
                this.animatorState = n;
                this.resumeHook();
                this.controllerHook();
                this.resumeAnimator();
                break;
            }
        }
    }

    private synchronized void suspendAnimator() {
        this.resumed = false;
        while (!this.resumed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void resumeAnimator() {
        this.resumed = true;
        this.notifyAll();
    }

    private void terminate() {
        this.animatorState = 6;
        if (Thread.currentThread() == this) {
            throw new ThreadDeath();
        }
        throw new ErrorException("Illegal call to terminate");
    }
}

