/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import stanford.cs106.io.IORuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private static final boolean DEBUG = false;
    private static Class<?> resourceLoaderClass = ResourceUtils.class;

    public static void setResourceLoaderClass(Class<?> clazz) {
        if (clazz != null) {
            resourceLoaderClass = clazz;
        }
    }

    public static boolean fileExists(String filename) {
        try {
            URL url = ResourceUtils.filenameToURL(filename);
            return url != null;
        }
        catch (IORuntimeException ioe) {
            return false;
        }
    }

    public static URL filenameToURL(String filename) {
        filename = filename.replace("\\", "/");
        File file = new File(filename);
        URL result = null;
        try {
            if (file.exists()) {
                result = new URL("file:" + filename.replace("\\", "/"));
            }
        }
        catch (MalformedURLException mfurle) {
            throw new IORuntimeException(mfurle);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (result == null) {
            result = resourceLoaderClass.getResource("/" + filename);
        }
        if (result == null) {
            throw new IORuntimeException(filename);
        }
        return result;
    }

    public static InputStream openFile(String filename) {
        try {
            InputStream stream = ResourceUtils.filenameToURL(filename).openStream();
            if (stream == null) {
                throw new IORuntimeException(filename);
            }
            return stream;
        }
        catch (IOException ioe) {
            throw new IORuntimeException("file not found: " + filename);
        }
    }
}

