/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import stanford.cs106.collections.Multimap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private Map<K, Collection<V>> map = this.createMap();
    private boolean isSet;

    public AbstractMultimap() {
        this(false);
    }

    public AbstractMultimap(boolean isSet) {
        this.isSet = isSet;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    protected abstract Map<K, Collection<V>> createMap();

    protected abstract Collection<V> createSet();

    protected Collection<V> createList() {
        return new ArrayList();
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.containsKey(key) && this.map.get(key).contains(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Collection<V> collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public boolean put(K key, V value) {
        Collection<V> coll;
        if (this.map.containsKey(key)) {
            coll = this.map.get(key);
        } else {
            coll = this.isSet ? this.createSet() : this.createList();
            this.map.put(key, coll);
        }
        return coll.add(value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (this.containsKey(key)) {
            Collection<V> coll = this.map.get(key);
            boolean result = coll.remove(value);
            if (coll.isEmpty()) {
                this.map.remove(key);
            }
            return result;
        }
        return false;
    }

    @Override
    public Collection<V> removeAll(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        int result = 0;
        for (Collection<V> coll : this.map.values()) {
            result += coll.size();
        }
        return result;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<V> values() {
        Collection<V> result = this.createList();
        for (Collection<V> coll : this.map.values()) {
            result.addAll(coll);
        }
        return Collections.unmodifiableCollection(result);
    }
}

