/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import stanford.cs106.io.IORuntimeException;
import stanford.cs106.io.LimitedPrintStream;

public class IOUtils {
    private static final InputStream SYSTEM_IN_ORIGINAL = System.in;
    private static final PrintStream SYSTEM_OUT_ORIGINAL = System.out;
    private static final PrintStream SYSTEM_ERR_ORIGINAL = System.err;

    private IOUtils() {
    }

    public static void copy(File in, File out) {
        try {
            int len;
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf)) >= 0) {
                fos.write(buf, 0, len);
            }
            fis.close();
            fos.close();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        return IOUtils.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dot = fileName.lastIndexOf(".");
        if (dot >= 0) {
            return fileName.substring(dot + 1);
        }
        return "";
    }

    public static String getFileName(String filePath) {
        return new File(filePath).getName();
    }

    public static String getFolder(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            slash = fileName.lastIndexOf("/");
        }
        if (slash >= 0) {
            return fileName.substring(0, slash + 1);
        }
        return "./";
    }

    public static String getTempFolder() {
        String tempFolder = System.getProperty("java.io.tmpdir");
        if (!tempFolder.endsWith(File.separator)) {
            tempFolder = String.valueOf(tempFolder) + File.separator;
        }
        return tempFolder;
    }

    public static String readEntireFile(File file) {
        try {
            FileReader fr = new FileReader(file);
            BufferedReader reader = new BufferedReader(fr);
            StringBuilder text = new StringBuilder();
            while (reader.ready()) {
                text.append((char)reader.read());
            }
            reader.close();
            fr.close();
            return text.toString();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public static String readEntireFile(String fileName) {
        return IOUtils.readEntireFile(new File(fileName));
    }

    public static byte[] readEntireStreamBytes(InputStream stream) {
        return IOUtils.readEntireReaderBytes(new InputStreamReader(stream));
    }

    public static byte[] readEntireReaderBytes(Reader reader) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int count = 0;
            while (reader.ready()) {
                int b = reader.read();
                out.write(b);
                System.out.printf("%4d: %3d (%s)\n", count, b, Character.valueOf((char)b));
                ++count;
            }
            return out.toByteArray();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public static byte[] readEntireFileBytes(String fileName) {
        return IOUtils.readEntireFileBytes(new File(fileName));
    }

    public static byte[] readEntireFileBytes(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            byte[] bytes = new byte[(int)file.length()];
            int total = 0;
            while (total < bytes.length) {
                int bytesRead = ((InputStream)stream).read(bytes, total, bytes.length - total);
                if (bytesRead < 0) break;
            }
            ((InputStream)stream).close();
            return bytes;
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public static InputStream toInputStream(String data) {
        if (data == null) {
            data = "";
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(data.length());
        PrintStream out = new PrintStream(stream);
        out.print(data);
        out.flush();
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(stream.toByteArray());
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redirectInput(String data) {
        Class<IOUtils> clazz = IOUtils.class;
        synchronized (IOUtils.class) {
            System.setIn(IOUtils.toInputStream(data));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static ByteArrayOutputStream redirectOutput() {
        return IOUtils.redirectOutput(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream redirectOutput(boolean limit) {
        ByteArrayOutputStream out = null;
        System.out.flush();
        System.err.flush();
        out = new ByteArrayOutputStream(2048);
        PrintStream outErr = null;
        outErr = limit ? new LimitedPrintStream(out) : new PrintStream(out);
        Class<IOUtils> clazz = IOUtils.class;
        synchronized (IOUtils.class) {
            System.setOut(outErr);
            System.setErr(outErr);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return out;
        }
    }

    public static String removeExtension(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot >= 0) {
            fileName = fileName.substring(0, dot);
        }
        return fileName;
    }

    public static String removeFolder(String fileName) {
        int slash = fileName.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            slash = fileName.lastIndexOf("/");
        }
        if (slash >= 0) {
            fileName = fileName.substring(slash + 1);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopRedirectingInput() {
        Class<IOUtils> clazz = IOUtils.class;
        synchronized (IOUtils.class) {
            System.setIn(SYSTEM_IN_ORIGINAL);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopRedirectingOutput() {
        System.out.flush();
        System.err.flush();
        Class<IOUtils> clazz = IOUtils.class;
        synchronized (IOUtils.class) {
            System.setOut(SYSTEM_OUT_ORIGINAL);
            System.setErr(SYSTEM_ERR_ORIGINAL);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void writeEntireFile(String text, String fileName) {
        IOUtils.writeEntireFile(text, new File(fileName));
    }

    public static void writeEntireFile(String text, File file) {
        try {
            PrintStream output = new PrintStream(file);
            output.print(text);
            output.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    public static void writeBytes(byte[] bytes, String fileName) {
        try {
            FileOutputStream output = new FileOutputStream(fileName);
            output.write(bytes);
            output.close();
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }
}

