/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.util.JTFTools;
import acm.util.MediaTools;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class GLabel
extends GObject {
    public static final Font DEFAULT_FONT = new Font("Default", 0, 12);
    private String label;
    private Font labelFont;
    private static final Component DUMMY_COMPONENT = MediaTools.getImageObserver();
    static final long serialVersionUID = 21L;

    public GLabel(String string) {
        this(string, 0.0, 0.0);
    }

    public GLabel(String string, double d, double d2) {
        this.label = string;
        this.setFont(DEFAULT_FONT);
        this.setLocation(d, d2);
    }

    public void setFont(Font font) {
        this.labelFont = JTFTools.getStandardFont(font);
        this.repaint();
    }

    public void setFont(String string) {
        this.setFont(JTFTools.decodeFont(string, this.getFont()));
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    protected void paint2d(Graphics2D graphics2D) {
        graphics2D.setFont(this.labelFont);
        graphics2D.drawString(this.label, 0, 0);
    }

    public double getAscent() {
        return this.getFontMetrics().getAscent();
    }

    public double getDescent() {
        return this.getFontMetrics().getDescent();
    }

    public FontMetrics getFontMetrics() {
        Component component = this.getComponent();
        if (component == null) {
            component = DUMMY_COMPONENT;
        }
        return component.getFontMetrics(this.labelFont);
    }

    public GRectangle getBounds() {
        FontMetrics fontMetrics = this.getFontMetrics();
        Shape shape = new Rectangle2D.Double(0.0, -fontMetrics.getAscent(), fontMetrics.stringWidth(this.label), fontMetrics.getHeight());
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        Rectangle rectangle = shape.getBounds();
        return new GRectangle(this.getX() + ((RectangularShape)rectangle).getX(), this.getY() + ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
    }

    public boolean contains(double d, double d2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        Shape shape = new Rectangle2D.Double(0.0, -fontMetrics.getAscent(), fontMetrics.stringWidth(this.label), fontMetrics.getHeight());
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape.contains(d - this.getX(), d2 - this.getY());
    }

    public String paramString() {
        return super.paramString() + ", string=\"" + this.label + "\"";
    }
}

