/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.VertexList;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;

public class GPolygon
extends GObject
implements GFillable {
    private VertexList vertices = new VertexList();
    private boolean complete;
    private boolean isFilled;
    private Color fillColor;
    static final long serialVersionUID = 21L;

    public GPolygon() {
        this.clear();
    }

    public GPolygon(double d, double d2) {
        this();
        this.setLocation(d, d2);
    }

    public GPolygon(GPoint[] gPointArray) {
        this();
        this.vertices.add(gPointArray);
        this.markAsComplete();
    }

    public void addVertex(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add vertices to a GPolygon that has been marked as complete.");
        }
        this.vertices.addVertex(d, d2);
    }

    public void addEdge(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addEdge(d, d2);
    }

    public final void addPolarEdge(double d, double d2) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addEdge(d * GMath.cosDegrees(d2), -d * GMath.sinDegrees(d2));
    }

    public void addArc(double d, double d2, double d3, double d4) {
        if (this.complete) {
            throw new ErrorException("You can't add edges to a GPolygon that has been marked as complete.");
        }
        this.vertices.addArc(d, d2, d3, d4);
    }

    public GPoint getCurrentPoint() {
        return this.vertices.getCurrentPoint();
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public GRectangle getBounds() {
        GRectangle gRectangle = this.vertices.getBounds(this.getMatrix());
        return new GRectangle(gRectangle.getX() + this.getX(), gRectangle.getY() + this.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public boolean contains(double d, double d2) {
        return this.vertices.contains(d - this.getX(), d2 - this.getY(), this.getMatrix());
    }

    protected void paint2d(Graphics2D graphics2D) {
        int n = this.vertices.size();
        Path2D.Double double_ = new Path2D.Double(0);
        ((Path2D)double_).moveTo(this.vertices.get(0).getX(), this.vertices.get(0).getY());
        for (int i = 0; i < n; ++i) {
            ((Path2D)double_).lineTo(this.vertices.get(i).getX(), this.vertices.get(i).getY());
        }
        ((Path2D)double_).lineTo(this.vertices.get(0).getX(), this.vertices.get(0).getY());
        if (this.isFilled()) {
            graphics2D.setColor(this.getFillColor());
            graphics2D.fill(double_);
            graphics2D.setColor(this.getColor());
        }
        graphics2D.draw(double_);
    }

    public void recenter() {
        this.vertices.recenter();
    }

    public Object clone() {
        try {
            GPolygon gPolygon = (GPolygon)super.clone();
            gPolygon.vertices = new VertexList(gPolygon.vertices);
            return gPolygon;
        }
        catch (Exception exception) {
            throw new ErrorException("Impossible exception");
        }
    }

    protected void markAsComplete() {
        this.complete = true;
    }

    protected void clear() {
        if (this.complete) {
            throw new ErrorException("You can't clear a GPolygon that has been marked as complete.");
        }
        this.vertices.clear();
    }
}

