/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.OldStyleCheckBoxMenuItem;
import acm.program.OldStyleMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuBarListener;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Component;
import java.awt.Container;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramMenuBar
extends JMenuBar
implements Iterable<JMenuItem> {
    public static final int SHIFT = 131072;
    private Program program;
    private ActionListener menuBarListener;
    private ActionListener focusedListener;
    private HashMap<KeyStroke, JMenuItem> accelerators;
    private HashSet<JMenuItem> focusedItems;
    private MenuBar oldStyleMenuBar;
    private boolean macMenuBarFlag;

    public ProgramMenuBar(Program program) {
        this.program = program;
        this.menuBarListener = new ProgramMenuBarListener(this);
        this.focusedListener = null;
        this.accelerators = new HashMap();
        this.focusedItems = new HashSet();
        this.macMenuBarFlag = true;
        this.addMenus();
    }

    public Program getProgram() {
        return this.program;
    }

    public JMenuItem createStandardItem(String string) {
        JMenuItem jMenuItem = null;
        if (string.equals("Quit")) {
            jMenuItem = this.createProgramItem(string);
            if (Platform.isMac()) {
                this.setAccelerator(jMenuItem, 81);
            } else {
                jMenuItem.setName("Exit");
            }
        } else if (string.equals("Cut")) {
            jMenuItem = this.createFocusedItem(string, 88);
            if (!Platform.isMac()) {
                jMenuItem.setName("Cut (x)");
            }
        } else if (string.equals("Copy")) {
            jMenuItem = this.createFocusedItem(string, 67);
            if (!Platform.isMac()) {
                jMenuItem.setName("Copy (c)");
            }
        } else if (string.equals("Paste")) {
            jMenuItem = this.createFocusedItem(string, 86);
            if (!Platform.isMac()) {
                jMenuItem.setName("Paste (v)");
            }
        } else if (string.equals("Select All")) {
            jMenuItem = this.createFocusedItem(string, 65);
        } else if (string.equals("Save")) {
            jMenuItem = this.createFocusedItem(string, 83);
        } else if (string.equals("Save As")) {
            jMenuItem = this.createFocusedItem(string);
        } else if (string.equals("Print")) {
            jMenuItem = this.createProgramItem(string, 80);
            jMenuItem.setName("Print...");
        } else if (string.equals("Print Console")) {
            jMenuItem = this.createProgramItem(string);
        } else if (string.equals("Script")) {
            jMenuItem = this.createProgramItem(string);
            jMenuItem.setName("Script...");
        } else if (string.equals("Export Applet")) {
            jMenuItem = this.createProgramItem(string);
            jMenuItem.setName("Export Applet...");
        } else if (string.equals("Submit Project")) {
            jMenuItem = this.createProgramItem(string);
            jMenuItem.setName("Submit Project...");
        } else {
            throw new ErrorException("Illegal standard menu item: " + string);
        }
        return jMenuItem;
    }

    public JMenuItem createProgramItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this.menuBarListener);
        return jMenuItem;
    }

    public JMenuItem createProgramItem(String string, int n) {
        JMenuItem jMenuItem = this.createProgramItem(string);
        this.setAccelerator(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem createFocusedItem(String string) {
        JMenuItem jMenuItem = this.createProgramItem(string);
        this.focusedItems.add(jMenuItem);
        return jMenuItem;
    }

    public JMenuItem createFocusedItem(String string, int n) {
        JMenuItem jMenuItem = this.createFocusedItem(string);
        this.setAccelerator(jMenuItem, n);
        return jMenuItem;
    }

    public boolean isFocusedItem(JMenuItem jMenuItem) {
        return this.focusedItems.contains(jMenuItem);
    }

    public void setAccelerator(JMenuItem jMenuItem, int n) {
        int n2;
        int n3 = n2 = Platform.isMac() ? 4 : 2;
        if (n > 65536) {
            n -= 131072;
            n2 |= 1;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)((char)n), n2);
        this.accelerators.put(keyStroke, jMenuItem);
        if (Platform.isMac()) {
            jMenuItem.setAccelerator(keyStroke);
        } else {
            jMenuItem.setMnemonic(n);
        }
    }

    public void setEnabled(String string, boolean bl) {
        int n = this.getMenuCount();
        for (int i = 0; i < n; ++i) {
            this.setEnabled(this.getMenu(i), string, bl);
        }
    }

    public void install(Component component) {
        Container container = this.program.getContentPane();
        while (component != null && !(component instanceof JFrame)) {
            if ((component = component.getParent()) != container || !this.program.isAppletMode()) continue;
            if (!Platform.isMac() || !this.macMenuBarFlag) {
                this.program.setJMenuBar(this);
            }
            return;
        }
        if (component == null) {
            return;
        }
        JFrame jFrame = (JFrame)component;
        if (Platform.isMac() && this.macMenuBarFlag) {
            if (this.oldStyleMenuBar == null) {
                this.oldStyleMenuBar = this.createOldStyleMenuBar();
            }
            jFrame.setMenuBar(this.oldStyleMenuBar);
        } else {
            jFrame.setJMenuBar(this);
            jFrame.validate();
        }
    }

    public void setMacMenuBarFlag(boolean bl) {
        this.macMenuBarFlag = bl;
    }

    public boolean getMacMenuBarFlag() {
        return this.macMenuBarFlag;
    }

    public void fireActionListeners(ActionEvent actionEvent) {
        if (this.focusedListener != null && this.focusedItems.contains(actionEvent.getSource())) {
            this.focusedListener.actionPerformed(actionEvent);
        } else {
            this.program.menuAction(actionEvent);
        }
    }

    public boolean fireAccelerator(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        JMenuItem jMenuItem = this.accelerators.get(keyStroke);
        if (jMenuItem != null) {
            jMenuItem.doClick(0);
            return true;
        }
        return false;
    }

    public void setFocusedListener(ActionListener actionListener) {
        this.focusedListener = actionListener;
    }

    @Override
    public Iterator<JMenuItem> iterator() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (int i = 0; i < this.getMenuCount(); ++i) {
            this.addItemToList(arrayList, this.getMenu(i));
        }
        return arrayList.iterator();
    }

    protected void addMenus() {
        this.addFileMenu();
        this.addEditMenu();
    }

    protected void addFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.addFileMenuItems(jMenu);
        this.add(jMenu);
    }

    protected void addEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        this.addEditMenuItems(jMenu);
        this.add(jMenu);
    }

    protected void addFileMenuItems(JMenu jMenu) {
        jMenu.add(this.createStandardItem("Save"));
        jMenu.add(this.createStandardItem("Save As"));
        jMenu.addSeparator();
        jMenu.add(this.createStandardItem("Print"));
        jMenu.add(this.createStandardItem("Print Console"));
        jMenu.add(this.createStandardItem("Script"));
        jMenu.addSeparator();
        jMenu.add(this.createStandardItem("Export Applet"));
        jMenu.add(this.createStandardItem("Submit Project"));
        jMenu.addSeparator();
        jMenu.add(this.createStandardItem("Quit"));
    }

    protected void addEditMenuItems(JMenu jMenu) {
        jMenu.add(this.createStandardItem("Cut"));
        jMenu.add(this.createStandardItem("Copy"));
        jMenu.add(this.createStandardItem("Paste"));
        jMenu.add(this.createStandardItem("Select All"));
    }

    private void addItemToList(ArrayList<JMenuItem> arrayList, JMenuItem jMenuItem) {
        if (jMenuItem == null) {
            return;
        }
        if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            for (int i = 0; i < jMenu.getItemCount(); ++i) {
                this.addItemToList(arrayList, jMenu.getItem(i));
            }
        } else {
            arrayList.add(jMenuItem);
        }
    }

    private MenuBar createOldStyleMenuBar() {
        MenuBar menuBar = new MenuBar();
        int n = this.getMenuCount();
        for (int i = 0; i < n; ++i) {
            menuBar.add(this.createOldStyleMenu(this.getMenu(i)));
        }
        return menuBar;
    }

    private Menu createOldStyleMenu(JMenu jMenu) {
        Menu menu = new Menu(jMenu.getText());
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            menu.add(this.createOldStyleMenuItem(jMenu.getItem(i)));
        }
        return menu;
    }

    private MenuItem createOldStyleMenuItem(Object object) {
        if (object == null) {
            return new MenuItem("-");
        }
        if (object instanceof JMenu) {
            return this.createOldStyleMenu((JMenu)object);
        }
        if (object instanceof JCheckBoxMenuItem) {
            return new OldStyleCheckBoxMenuItem((JCheckBoxMenuItem)object);
        }
        if (object instanceof JMenuItem) {
            return new OldStyleMenuItem((JMenuItem)object);
        }
        throw new ErrorException("Unsupported menu item type");
    }

    private void setEnabled(JMenu jMenu, String string, boolean bl) {
        JMenu jMenu2 = jMenu;
        int n = jMenu2.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu2.getItem(i);
            if (jMenuItem == null) continue;
            this.setEnabled(jMenuItem, string, bl);
        }
    }

    private void setEnabled(JMenuItem jMenuItem, String string, boolean bl) {
        if (string.equals(jMenuItem.getActionCommand())) {
            jMenuItem.setEnabled(bl);
        }
    }
}

