/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.MediaTools;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;

class ImageSaver {
    private OutputStream out;
    private String formatName;
    private int bufferType;

    public ImageSaver() {
    }

    public ImageSaver(String string, int n) {
        this.formatName = string;
        this.bufferType = n;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void saveImage(Image image) {
        BufferedImage bufferedImage = MediaTools.createBufferedImage(image, this.bufferType);
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(this.getOutputStream());
        try {
            if (!ImageIO.write((RenderedImage)bufferedImage, this.formatName, memoryCacheImageOutputStream)) {
                throw new IOException("ImageIO.write failed");
            }
            memoryCacheImageOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ErrorException("saveImage: " + iOException.getMessage());
        }
    }

    public void updateFileType(File file) {
    }

    public void dumpByte(int n) {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new ErrorException("saveImage: " + iOException.getMessage());
        }
    }

    public void dumpShort(int n) {
        try {
            this.out.write(n >> 8);
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new ErrorException("saveImage: " + iOException.getMessage());
        }
    }

    public void dumpLong(int n) {
        try {
            this.out.write(n >> 24);
            this.out.write(n >> 16);
            this.out.write(n >> 8);
            this.out.write(n);
        }
        catch (IOException iOException) {
            throw new ErrorException("saveImage: " + iOException.getMessage());
        }
    }

    public int getPixelComponent(int n, char c) {
        int n2 = n >> 24 & 0xFF;
        switch (c) {
            case 'R': {
                n >>= 16;
                break;
            }
            case 'G': {
                n >>= 8;
                break;
            }
            case 'B': {
                break;
            }
            default: {
                throw new ErrorException("getPixelComponent: Illegal color");
            }
        }
        return (n2 * (n &= 0xFF) + (255 - n2) * 255) / 255;
    }
}

