/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.JTFTools;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;

public class FileChooserFilter
extends FileFilter {
    private String filenamePattern;
    private String filenameDescription;
    private String dir;

    public FileChooserFilter(String string) {
        this(string, (string.isEmpty() ? "All" : string) + " files");
    }

    public FileChooserFilter(String string, String string2) {
        this.filenameDescription = string2;
        int n = Math.max(string.lastIndexOf("/"), string.lastIndexOf(92));
        this.filenamePattern = string.substring(n + 1);
        String string3 = this.dir = n == -1 ? "" : string.substring(0, n);
        if (this.dir.isEmpty()) {
            this.dir = System.getProperty("user.dir");
        } else if (!this.dir.startsWith("/")) {
            this.dir = System.getProperty("user.dir") + "/" + this.dir;
        }
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getPattern() {
        return this.filenamePattern;
    }

    public String getDescription() {
        return this.filenameDescription;
    }

    public boolean accept(File file) {
        if (file.isDirectory() || this.filenamePattern.isEmpty()) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.filenamePattern, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.length() <= 0 || !JTFTools.matchFilenamePattern(file.getName(), string)) continue;
            return true;
        }
        return false;
    }
}

