/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.io.IOConsole;
import acm.program.ProgramMenuBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import stanford.spl.JBEDummyProgram;
import stanford.spl.JavaBackEnd;

public class JBEMenuBar
extends ProgramMenuBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JMenuItem saveItem;
    private JMenuItem quitItem;
    private JMenuItem aboutItem;
    private KeyStroke CTRL_S;
    private KeyStroke COMMAND_S;
    private KeyStroke CTRL_Q;
    private KeyStroke CTRL_W;
    private KeyStroke COMMAND_Q;
    private KeyStroke COMMAND_W;
    private KeyStroke ALT_F4;
    private KeyStroke F1;
    private JavaBackEnd javaBackEnd;

    public JBEMenuBar(JavaBackEnd paramJavaBackEnd, IOConsole paramIOConsole) {
        super(new JBEDummyProgram(paramJavaBackEnd));
        this.getProgram().setConsole(paramIOConsole);
        this.javaBackEnd = paramJavaBackEnd;
    }

    protected void addMenus() {
        this.CTRL_S = KeyStroke.getKeyStroke(83, 128);
        this.COMMAND_S = KeyStroke.getKeyStroke(83, 256);
        this.CTRL_Q = KeyStroke.getKeyStroke(81, 128);
        this.CTRL_W = KeyStroke.getKeyStroke(87, 128);
        this.COMMAND_Q = KeyStroke.getKeyStroke(81, 256);
        this.COMMAND_W = KeyStroke.getKeyStroke(87, 256);
        this.ALT_F4 = KeyStroke.getKeyStroke(115, 512);
        this.F1 = KeyStroke.getKeyStroke(112, 0);
        super.addMenus();
        this.addHelpMenu();
    }

    protected void addFileMenuItems(JMenu fileMenu) {
        this.saveItem = this.createStandardItem("Save As");
        this.saveItem.setMnemonic('S');
        this.saveItem.setAccelerator(this.CTRL_S);
        fileMenu.add(this.saveItem);
        this.quitItem = this.createStandardItem("Quit");
        this.quitItem.setMnemonic('Q');
        this.quitItem.setAccelerator(this.ALT_F4);
        fileMenu.add(this.quitItem);
    }

    protected void addHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        this.aboutItem = this.createProgramItem("About");
        this.aboutItem.addActionListener(this);
        this.aboutItem.setMnemonic('A');
        this.aboutItem.setAccelerator(this.F1);
        this.setAccelerator(this.aboutItem, 112);
        helpMenu.add(this.aboutItem);
        this.add(helpMenu);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("About")) {
            JOptionPane.showMessageDialog(this.getProgram().getConsole(), "Stanford C++ Library version " + this.javaBackEnd.getCppVersion() + "\n" + "Java Back-End (spl.jar) version " + this.javaBackEnd.getJbeVersion() + "\n\n" + "Libraries written by Eric Roberts,\n" + "with assistance from Julie Zelenski, Keith Schwarz, et al.\n" + "Libraries currently unofficially maintained by Marty Stepp.", "About Stanford C++ Library", 1);
        }
    }

    public boolean fireAccelerator(KeyEvent event) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(event);
        if (ks.equals(this.CTRL_S) || ks.equals(this.COMMAND_S)) {
            this.saveItem.doClick(0);
        } else if (ks.equals(this.CTRL_Q) || ks.equals(this.CTRL_W) || ks.equals(this.COMMAND_Q) || ks.equals(this.COMMAND_W) || ks.equals(this.ALT_F4)) {
            this.quitItem.doClick(0);
        } else if (ks.equals(this.F1)) {
            this.aboutItem.doClick(0);
        }
        return super.fireAccelerator(event);
    }
}

