/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;

class VertexList
implements Serializable {
    private ArrayList<GPoint> vertices = new ArrayList();
    private double cx = 0.0;
    private double cy = 0.0;

    public VertexList() {
    }

    public VertexList(VertexList vertexList) {
        this();
        for (int i = 0; i < vertexList.vertices.size(); ++i) {
            this.vertices.add(vertexList.vertices.get(i));
        }
    }

    public synchronized void addVertex(double d, double d2) {
        this.cx = d;
        this.cy = d2;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public synchronized void addEdge(double d, double d2) {
        this.cx += d;
        this.cy += d2;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public void addArc(double d, double d2, double d3, double d4) {
        double d5 = d2 / d;
        double d6 = d / 2.0;
        double d7 = d2 / 2.0;
        double d8 = this.cx - d6 * GMath.cosDegrees(d3);
        double d9 = this.cy + d7 * GMath.sinDegrees(d3);
        if (d4 > 359.99) {
            d4 = 360.0;
        }
        if (d4 < -359.99) {
            d4 = -360.0;
        }
        double d10 = Math.atan2(1.0, Math.max(d, d2));
        int n = (int)(GMath.toRadians(Math.abs(d4)) / d10);
        d10 = GMath.toRadians(d4) / (double)n;
        double d11 = GMath.toRadians(d3);
        for (int i = 0; i < n; ++i) {
            double d12 = d8 + d6 * Math.cos(d11 += d10);
            double d13 = d9 - d6 * Math.sin(d11) * d5;
            this.addVertex(d12, d13);
        }
    }

    public synchronized void add(GPoint[] gPointArray) {
        for (int i = 0; i < gPointArray.length; ++i) {
            this.vertices.add(new GPoint(gPointArray[i].getX(), gPointArray[i].getY()));
        }
    }

    public synchronized void remove(GPoint gPoint) {
        this.vertices.remove(gPoint);
    }

    public synchronized void clear() {
        this.vertices.clear();
    }

    public int size() {
        return this.vertices.size();
    }

    GPoint get(int n) {
        return this.vertices.get(n);
    }

    public GPoint getCurrentPoint() {
        return this.vertices.size() == 0 ? null : new GPoint(this.cx, this.cy);
    }

    public synchronized GRectangle getBounds(AffineTransform affineTransform) {
        int n = this.vertices.size();
        if (n == 0) {
            return new GRectangle();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            Point2D.Double double_ = new Point2D.Double(gPoint.getX(), gPoint.getY());
            if (affineTransform != null) {
                affineTransform.transform(double_, double_);
            }
            double d5 = ((Point2D)double_).getX();
            double d6 = ((Point2D)double_).getY();
            if (bl) {
                d = d5;
                d2 = d5;
                d3 = d6;
                d4 = d6;
                bl = false;
                continue;
            }
            d = Math.min(d, d5);
            d2 = Math.max(d2, d5);
            d3 = Math.min(d3, d6);
            d4 = Math.max(d4, d6);
        }
        return new GRectangle(d, d3, d2 - d, d4 - d3);
    }

    public synchronized boolean contains(double d, double d2, AffineTransform affineTransform) {
        int n = this.vertices.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            GPoint gPoint = this.vertices.get(i);
            Point2D.Double double_ = new Point2D.Double(gPoint.getX(), gPoint.getY());
            if (affineTransform != null) {
                affineTransform.transform(double_, double_);
            }
            gPoint = this.vertices.get((i + 1) % n);
            Point2D.Double double_2 = new Point2D.Double(gPoint.getX(), gPoint.getY());
            if (affineTransform != null) {
                affineTransform.transform(double_2, double_2);
            }
            if (!(((Point2D)double_).getY() < d2 && ((Point2D)double_2).getY() >= d2) && (!(((Point2D)double_2).getY() < d2) || !(((Point2D)double_).getY() >= d2)) || !(((Point2D)double_).getX() + (d2 - ((Point2D)double_).getY()) / (((Point2D)double_2).getY() - ((Point2D)double_).getY()) * (((Point2D)double_2).getX() - ((Point2D)double_).getX()) < d)) continue;
            bl = !bl;
        }
        return bl;
    }

    public void recenter() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = true;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            if (bl) {
                d = gPoint.getX();
                d2 = gPoint.getX();
                d3 = gPoint.getY();
                d4 = gPoint.getY();
                bl = false;
                continue;
            }
            d = Math.min(d, gPoint.getX());
            d2 = Math.max(d2, gPoint.getX());
            d3 = Math.min(d3, gPoint.getY());
            d4 = Math.max(d4, gPoint.getY());
        }
        double d5 = (d + d2) / 2.0;
        double d6 = (d3 + d4) / 2.0;
        for (int i = 0; i < this.vertices.size(); ++i) {
            GPoint gPoint = this.vertices.get(i);
            gPoint.translate(-d5, -d6);
        }
    }
}

