/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.program.ConsoleProgram;
import acm.program.OldStyleCheckBoxMenuItem;
import acm.program.OldStyleMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuBarListener;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Component;
import java.awt.Container;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import stanford.spl.JBEDummyProgram;
import stanford.spl.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgramMenuBar
extends JMenuBar
implements ActionListener,
Iterable<JMenuItem> {
    protected KeyStroke ALT_F4;
    protected KeyStroke COMMAND_A;
    protected KeyStroke COMMAND_C;
    protected KeyStroke COMMAND_END;
    protected KeyStroke COMMAND_HOME;
    protected KeyStroke COMMAND_L;
    protected KeyStroke COMMAND_P;
    protected KeyStroke COMMAND_Q;
    protected KeyStroke COMMAND_S;
    protected KeyStroke COMMAND_V;
    protected KeyStroke COMMAND_W;
    protected KeyStroke COMMAND_X;
    protected KeyStroke CTRL_A;
    protected KeyStroke CTRL_C;
    protected KeyStroke CTRL_END;
    protected KeyStroke CTRL_HOME;
    protected KeyStroke CTRL_L;
    protected KeyStroke CTRL_P;
    protected KeyStroke CTRL_Q;
    protected KeyStroke CTRL_S;
    protected KeyStroke CTRL_V;
    protected KeyStroke CTRL_W;
    protected KeyStroke CTRL_X;
    protected KeyStroke DOWN_ARROW;
    protected KeyStroke F1;
    protected KeyStroke PGDN;
    protected KeyStroke PGUP;
    protected KeyStroke UP_ARROW;
    public static final int SHIFT = 131072;
    private Program program;
    private ActionListener menuBarListener;
    private ActionListener focusedListener;
    private HashMap<KeyStroke, JMenuItem> accelerators;
    private HashSet<JMenuItem> focusedItems;
    private MenuBar oldStyleMenuBar;
    private boolean macMenuBarFlag;

    public ProgramMenuBar(Program owner) {
        this.program = owner;
        this.menuBarListener = new ProgramMenuBarListener(this);
        this.focusedListener = null;
        this.accelerators = new HashMap();
        this.focusedItems = new HashSet();
        this.macMenuBarFlag = true;
        this.ALT_F4 = KeyStroke.getKeyStroke(115, 512);
        this.COMMAND_A = KeyStroke.getKeyStroke(65, 256);
        this.COMMAND_C = KeyStroke.getKeyStroke(67, 256);
        this.COMMAND_END = KeyStroke.getKeyStroke(35, 256);
        this.COMMAND_HOME = KeyStroke.getKeyStroke(36, 256);
        this.COMMAND_L = KeyStroke.getKeyStroke(76, 256);
        this.COMMAND_P = KeyStroke.getKeyStroke(80, 256);
        this.COMMAND_Q = KeyStroke.getKeyStroke(81, 256);
        this.COMMAND_S = KeyStroke.getKeyStroke(83, 256);
        this.COMMAND_V = KeyStroke.getKeyStroke(86, 256);
        this.COMMAND_W = KeyStroke.getKeyStroke(87, 256);
        this.CTRL_A = KeyStroke.getKeyStroke(65, 128);
        this.CTRL_C = KeyStroke.getKeyStroke(67, 128);
        this.CTRL_END = KeyStroke.getKeyStroke(35, 128);
        this.CTRL_HOME = KeyStroke.getKeyStroke(36, 128);
        this.CTRL_L = KeyStroke.getKeyStroke(76, 128);
        this.CTRL_P = KeyStroke.getKeyStroke(80, 128);
        this.CTRL_Q = KeyStroke.getKeyStroke(81, 128);
        this.CTRL_S = KeyStroke.getKeyStroke(83, 128);
        this.CTRL_V = KeyStroke.getKeyStroke(86, 128);
        this.CTRL_W = KeyStroke.getKeyStroke(87, 128);
        this.DOWN_ARROW = KeyStroke.getKeyStroke(40, 0);
        this.F1 = KeyStroke.getKeyStroke(112, 0);
        this.PGDN = KeyStroke.getKeyStroke(34, 0);
        this.PGUP = KeyStroke.getKeyStroke(33, 0);
        this.UP_ARROW = KeyStroke.getKeyStroke(38, 0);
        this.addMenus();
    }

    public Program getProgram() {
        return this.program;
    }

    public JMenuItem createStandardItem(String action, int mnemonic) {
        return this.createStandardItem(action, mnemonic, null);
    }

    public JMenuItem createStandardItem(String action, int mnemonic, KeyStroke keystroke) {
        boolean mac = Platform.isMac();
        JMenuItem item = null;
        if (action.equals("Quit")) {
            item = this.createProgramItem(action, 81, mac ? this.COMMAND_Q : this.ALT_F4);
            if (mac) {
                this.setAccelerator(item, 81);
            } else {
                item.setName("Exit");
            }
        } else if (action.equals("Cut")) {
            item = this.createFocusedItem(action, 88, mac ? this.COMMAND_X : this.CTRL_X);
            item.setMnemonic('t');
            if (!mac) {
                item.setName("Cut (x)");
            }
        } else if (action.equals("Copy")) {
            item = this.createFocusedItem(action, 67, mac ? this.COMMAND_C : this.CTRL_C);
            if (!mac) {
                item.setName("Copy (c)");
            }
        } else if (action.equals("Paste")) {
            item = this.createFocusedItem(action, 86, mac ? this.COMMAND_V : this.CTRL_V);
            item.setMnemonic('P');
            if (!mac) {
                item.setName("Paste (v)");
            }
        } else if (action.equals("Clear Console")) {
            item = this.createProgramItem(action, 76, mac ? this.COMMAND_L : this.CTRL_L);
        } else if (action.equals("Select All")) {
            item = this.createFocusedItem(action, 65, mac ? this.COMMAND_A : this.CTRL_A);
        } else if (action.equals("Save")) {
            item = this.createFocusedItem(action, 83, mac ? this.COMMAND_S : this.CTRL_S);
        } else if (action.equals("Save As...")) {
            item = this.createFocusedItem(action, 65);
        } else if (action.equals("Print...")) {
            item = this.createProgramItem(action, 80, mac ? this.COMMAND_P : this.CTRL_P);
            item.setName("Print...");
        } else if (action.equals("Print Console")) {
            item = this.createProgramItem(action);
        } else if (action.equals("Script")) {
            item = this.createProgramItem(action);
            item.setName("Script...");
        } else if (action.equals("Export Applet")) {
            item = this.createProgramItem(action);
            item.setName("Export Applet...");
        } else if (action.equals("Submit Project")) {
            item = this.createProgramItem(action);
            item.setName("Submit Project...");
        } else {
            throw new ErrorException("Illegal standard menu item: " + action);
        }
        if (keystroke != null) {
            item.setAccelerator(keystroke);
        }
        return item;
    }

    public JMenuItem createProgramItem(String action) {
        JMenuItem item = new JMenuItem(action);
        item.setActionCommand(action);
        item.addActionListener(this.menuBarListener);
        return item;
    }

    public JMenuItem createProgramItem(String action, int key, KeyStroke keystroke) {
        JMenuItem item = this.createProgramItem(action, key);
        item.setAccelerator(keystroke);
        item.setMnemonic(key);
        return item;
    }

    public JMenuItem createProgramItem(String action, int key) {
        JMenuItem item = this.createProgramItem(action);
        this.setAccelerator(item, key);
        item.setMnemonic(key);
        return item;
    }

    public JMenuItem createFocusedItem(String action) {
        JMenuItem item = this.createProgramItem(action);
        this.focusedItems.add(item);
        return item;
    }

    public JMenuItem createFocusedItem(String action, int key) {
        return this.createFocusedItem(action, key, null, false);
    }

    public JMenuItem createFocusedItem(String action, int key, KeyStroke keystroke) {
        return this.createFocusedItem(action, key, keystroke, true);
    }

    public JMenuItem createFocusedItem(String action, int key, KeyStroke keystroke, boolean shouldSetAccelerator) {
        JMenuItem item = this.createFocusedItem(action);
        if (keystroke != null) {
            item.setAccelerator(keystroke);
            this.accelerators.put(keystroke, item);
        } else if (shouldSetAccelerator && key != 32 && key != 0) {
            this.setAccelerator(item, key);
        }
        item.setMnemonic(key);
        return item;
    }

    public boolean isFocusedItem(JMenuItem item) {
        return this.focusedItems.contains(item);
    }

    public void setAccelerator(JMenuItem item, int key) {
        int mask;
        int n = mask = Platform.isMac() ? 4 : 2;
        if (key > 65536) {
            key -= 131072;
            mask |= 1;
        }
        KeyStroke stroke = KeyStroke.getKeyStroke((int)((char)key), mask);
        this.accelerators.put(stroke, item);
        if (Platform.isMac()) {
            item.setAccelerator(stroke);
        } else {
            item.setMnemonic(key);
        }
    }

    public void setEnabled(String action, boolean flag) {
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            this.setEnabled(this.getMenu(i), action, flag);
            ++i;
        }
    }

    public void install(Component comp) {
        Container contentPane = this.program.getContentPane();
        while (comp != null && !(comp instanceof JFrame)) {
            if ((comp = comp.getParent()) != contentPane || !this.program.isAppletMode()) continue;
            if (!Platform.isMac() || !this.macMenuBarFlag) {
                this.program.setJMenuBar(this);
            }
            return;
        }
        if (comp == null) {
            return;
        }
        JFrame frame = (JFrame)comp;
        if (Platform.isMac() && this.macMenuBarFlag) {
            if (this.oldStyleMenuBar == null) {
                this.oldStyleMenuBar = this.createOldStyleMenuBar();
            }
            frame.setMenuBar(this.oldStyleMenuBar);
        } else {
            frame.setJMenuBar(this);
            frame.validate();
        }
    }

    public void setMacMenuBarFlag(boolean flag) {
        this.macMenuBarFlag = flag;
    }

    public boolean getMacMenuBarFlag() {
        return this.macMenuBarFlag;
    }

    public void fireActionListeners(ActionEvent e) {
        if (this.focusedListener != null && this.focusedItems.contains(e.getSource())) {
            this.focusedListener.actionPerformed(e);
        } else {
            this.program.menuAction(e);
        }
    }

    public boolean fireAccelerator(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        JMenuItem item = this.accelerators.get(stroke);
        if (item != null) {
            item.doClick(0);
            return true;
        }
        if (this.getProgram() instanceof ConsoleProgram) {
            ConsoleProgram consoleProgram = (ConsoleProgram)this.getProgram();
            if (stroke.equals(this.CTRL_HOME) || stroke.equals(this.COMMAND_HOME)) {
                consoleProgram.scrollToTop();
                return true;
            }
            if (stroke.equals(this.CTRL_END) || stroke.equals(this.COMMAND_END)) {
                consoleProgram.scrollToBottom();
                return true;
            }
            if (stroke.equals(this.PGUP)) {
                consoleProgram.scrollPageUp();
                return true;
            }
            if (stroke.equals(this.UP_ARROW)) {
                consoleProgram.scrollLineUp();
                return true;
            }
            if (stroke.equals(this.DOWN_ARROW)) {
                consoleProgram.scrollLineDown();
                return true;
            }
            if (stroke.equals(this.PGDN)) {
                consoleProgram.scrollPageDown();
                return true;
            }
        }
        return false;
    }

    public void setFocusedListener(ActionListener listener) {
        this.focusedListener = listener;
    }

    @Override
    public Iterator<JMenuItem> iterator() {
        ArrayList<JMenuItem> itemList = new ArrayList<JMenuItem>();
        int i = 0;
        while (i < this.getMenuCount()) {
            this.addItemToList(itemList, this.getMenu(i));
            ++i;
        }
        return itemList.iterator();
    }

    protected void addMenus() {
        boolean isConsole;
        this.addFileMenu();
        boolean bl = isConsole = this.getProgram() instanceof ConsoleProgram || this.getProgram() instanceof JBEDummyProgram;
        if (isConsole) {
            this.addEditMenu();
        }
        this.addHelpMenu();
    }

    protected void addFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.addFileMenuItems(fileMenu);
        this.add(fileMenu);
    }

    protected void addEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        this.addEditMenuItems(editMenu);
        this.add(editMenu);
    }

    protected void addHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('H');
        JMenuItem aboutItem = new JMenuItem("About...");
        aboutItem.addActionListener(this);
        aboutItem.setAccelerator(this.F1);
        this.accelerators.put(this.F1, aboutItem);
        aboutItem.setMnemonic('A');
        helpMenu.add(aboutItem);
        this.add(helpMenu);
    }

    protected String getAboutMessage() {
        String message = "Stanford Java Library (spl.jar) version " + Version.getLibraryVersion() + "\n\n" + "Libraries originally written by Eric Roberts,\n" + "with assistance from Julie Zelenski, Keith Schwarz, et al.\n" + "This version of the library is unofficially maintained by Marty Stepp.";
        return message;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("About...")) {
            JOptionPane.showMessageDialog(this.getProgram().getConsole(), this.getAboutMessage(), "About Stanford Java/C++ Library", 1);
        }
    }

    protected void addFileMenuItems(JMenu menu) {
        boolean isConsole = this.getProgram() instanceof ConsoleProgram;
        if (isConsole) {
            menu.add(this.createStandardItem("Save", 83));
            menu.add(this.createStandardItem("Save As...", 65));
            menu.addSeparator();
            menu.add(this.createStandardItem("Print...", 80));
            menu.addSeparator();
        }
        menu.add(this.createStandardItem("Quit", 81));
    }

    protected void addEditMenuItems(JMenu menu) {
        menu.add(this.createStandardItem("Cut", 67));
        menu.add(this.createStandardItem("Copy", 111));
        menu.add(this.createStandardItem("Paste", 80));
        menu.add(this.createStandardItem("Select All", 65));
        menu.addSeparator();
        menu.add(this.createStandardItem("Clear Console", 108));
    }

    private void addItemToList(ArrayList<JMenuItem> itemList, JMenuItem item) {
        if (item == null) {
            return;
        }
        if (item instanceof JMenu) {
            JMenu menu = (JMenu)item;
            int i = 0;
            while (i < menu.getItemCount()) {
                this.addItemToList(itemList, menu.getItem(i));
                ++i;
            }
        } else {
            itemList.add(item);
        }
    }

    private MenuBar createOldStyleMenuBar() {
        MenuBar mbar = new MenuBar();
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            mbar.add(this.createOldStyleMenu(this.getMenu(i)));
            ++i;
        }
        return mbar;
    }

    private Menu createOldStyleMenu(JMenu jmenu) {
        Menu menu = new Menu(jmenu.getText());
        int nItems = jmenu.getItemCount();
        int i = 0;
        while (i < nItems) {
            menu.add(this.createOldStyleMenuItem(jmenu.getItem(i)));
            ++i;
        }
        return menu;
    }

    private MenuItem createOldStyleMenuItem(Object jitem) {
        if (jitem == null) {
            return new MenuItem("-");
        }
        if (jitem instanceof JMenu) {
            return this.createOldStyleMenu((JMenu)jitem);
        }
        if (jitem instanceof JCheckBoxMenuItem) {
            return new OldStyleCheckBoxMenuItem((JCheckBoxMenuItem)jitem);
        }
        if (jitem instanceof JMenuItem) {
            return new OldStyleMenuItem((JMenuItem)jitem);
        }
        throw new ErrorException("Unsupported menu item type");
    }

    private void setEnabled(JMenu item, String action, boolean flag) {
        JMenu menu = item;
        int nItems = menu.getItemCount();
        int i = 0;
        while (i < nItems) {
            JMenuItem subItem = menu.getItem(i);
            if (subItem != null) {
                this.setEnabled(subItem, action, flag);
            }
            ++i;
        }
    }

    private void setEnabled(JMenuItem item, String action, boolean flag) {
        if (action.equals(item.getActionCommand())) {
            item.setEnabled(flag);
        }
    }
}

