/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import acm.graphics.GObject;
import acm.io.ConsoleModel;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import acm.util.TokenScanner;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import stanford.spl.AutograderInput;
import stanford.spl.GInteractor;
import stanford.spl.GTimer;
import stanford.spl.JBECanvas;
import stanford.spl.JBECommand;
import stanford.spl.JBEConsole;
import stanford.spl.JBEFileFilter;
import stanford.spl.JBELabel;
import stanford.spl.JBEMenuBar;
import stanford.spl.JBEWindow;
import stanford.spl.TopCompound;
import stanford.spl.Version;

public class JavaBackEnd
implements WindowListener,
MouseListener,
MouseMotionListener,
KeyListener,
ActionListener,
ComponentListener,
ChangeListener,
Observer {
    public static final int DEFAULT_CONSOLE_X = 10;
    public static final int DEFAULT_CONSOLE_Y = 40;
    public static final int DEFAULT_CONSOLE_WIDTH = 500;
    public static final int DEFAULT_CONSOLE_HEIGHT = 250;
    public static final int DEFAULT_GRAPHICS_X = 10;
    public static final int DEFAULT_GRAPHICS_Y = 10;
    public static final int EVENT_SUBTYPE_MASK = 15;
    public static final int ACTION_EVENT = 16;
    public static final int KEY_EVENT = 32;
    public static final int TIMER_EVENT = 64;
    public static final int WINDOW_EVENT = 128;
    public static final int MOUSE_EVENT = 256;
    public static final int CLICK_EVENT = 512;
    public static final int ANY_EVENT = 1008;
    public static final int WINDOW_CLOSED = 129;
    public static final int WINDOW_RESIZED = 130;
    public static final int ACTION_PERFORMED = 17;
    public static final int MOUSE_CLICKED = 257;
    public static final int MOUSE_PRESSED = 258;
    public static final int MOUSE_RELEASED = 259;
    public static final int MOUSE_MOVED = 260;
    public static final int MOUSE_DRAGGED = 261;
    public static final int KEY_PRESSED = 33;
    public static final int KEY_RELEASED = 34;
    public static final int KEY_TYPED = 35;
    public static final int TIMER_TICKED = 65;
    public static final int SHIFT_DOWN = 1;
    public static final int CTRL_DOWN = 2;
    public static final int META_DOWN = 4;
    public static final int ALT_DOWN = 8;
    public static final int ALT_GRAPH_DOWN = 16;
    public static final int BUTTON1_DOWN = 32;
    public static final int BUTTON2_DOWN = 64;
    public static final int BUTTON3_DOWN = 128;
    private static final String DEBUG_PROPERTY = "stanfordspl.debug";
    private static final String DEBUG_LOG_FILE = "stanfordspldebug.txt";
    private static boolean DEBUG = false;
    private String appName;
    private String exec;
    private String cppVersion = "(unknown)";
    private String consoleWindowTitle = "Console";
    private JBEMenuBar menuBar;
    private JBEConsole console;
    private JFrame consoleFrame;
    private int consoleCloseOperation = 1;
    private static final Color ERROR_COLOR = new Color(192, 0, 0);
    private static final int ERROR_STYLE = 1;
    private int consoleX = 10;
    private int consoleY = 40;
    private int consoleWidth = 500;
    private int consoleHeight = 250;
    private HashMap<String, JBECommand> cmdTable;
    private HashMap<String, JBEWindow> windowTable;
    private HashMap<String, GObject> gobjTable;
    private HashMap<String, GTimer> timerTable;
    private HashMap<String, Image> imageTable;
    private HashMap<String, Clip> clipTable;
    private HashMap<String, Clip> clipIdTable;
    private HashMap<JComponent, String> sourceTable;
    private Container empty = JTFTools.createEmptyContainer();
    private int activeWindowCount;
    private int eventMask;
    private Object eventLock = new Object();
    private boolean eventAcknowledged;
    private boolean eventPending;

    public static void main(String[] paramArrayOfString) {
        try {
            String prop = System.getProperty(DEBUG_PROPERTY);
            DEBUG = prop != null && (prop.startsWith("t") || prop.startsWith("1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        new JavaBackEnd().run(paramArrayOfString);
    }

    public void update(Observable obs, Object arg) {
        String input = (String)arg;
        this.console.setInputScript(new BufferedReader(new StringReader(input)));
    }

    public void setExitOnConsoleClose(boolean value) {
        if (value) {
            this.setConsoleCloseOperation(3);
        } else {
            this.setConsoleCloseOperation(1);
        }
    }

    public void setCppVersion(String version) {
        this.cppVersion = version;
    }

    public String getCppVersion() {
        return this.cppVersion;
    }

    public String getJbeVersion() {
        return Version.getLibraryVersion();
    }

    public JBEConsole getJBEConsole() {
        return this.console;
    }

    public int getJBEConsoleWidth() {
        return this.consoleWidth;
    }

    public int getJBEConsoleHeight() {
        return this.consoleHeight;
    }

    public JFrame getJBEConsoleFrame() {
        return this.consoleFrame;
    }

    public void run(String[] paramArrayOfString) {
        this.processArguments(paramArrayOfString);
        this.initSystemProperties();
        this.cmdTable = JBECommand.createCommandTable();
        this.imageTable = new HashMap();
        this.windowTable = new HashMap();
        this.gobjTable = new HashMap();
        this.timerTable = new HashMap();
        this.clipTable = new HashMap();
        this.clipIdTable = new HashMap();
        this.sourceTable = new HashMap();
        this.eventMask = 0;
        this.eventAcknowledged = false;
        this.eventPending = false;
        this.activeWindowCount = 0;
        this.console = new JBEConsole();
        this.console.setErrorColor(ERROR_COLOR);
        this.console.setErrorStyle(1);
        AutograderInput autograderInput = AutograderInput.getInstance(this);
        autograderInput.addObserver(this);
        this.menuBar = new JBEMenuBar(this, this.console);
        this.console.setMenuBar(this.menuBar);
        if (this.exec != null) {
            try {
                Process localProcess = Runtime.getRuntime().exec(this.exec);
                System.setIn(localProcess.getInputStream());
                System.setOut(new PrintStream(localProcess.getOutputStream(), true));
            }
            catch (IOException localIOException) {
                System.err.println("Can't exec process");
            }
        }
        this.commandLoop();
    }

    public void createWindow(String paramString, int paramInt1, int paramInt2, TopCompound paramTopCompound) {
        this.createWindow(paramString, paramInt1, paramInt2, paramTopCompound, true);
    }

    public void createWindow(String paramString, int paramInt1, int paramInt2, TopCompound paramTopCompound, boolean visible) {
        JBEWindow localJBEWindow = new JBEWindow(this, paramString, this.appName, paramInt1, paramInt2);
        this.windowTable.put(paramString, localJBEWindow);
        localJBEWindow.pack();
        localJBEWindow.setLocation(10, 10);
        localJBEWindow.getCanvas().initOffscreenImage();
        localJBEWindow.getCanvas().setTopCompound(paramTopCompound);
        ++this.activeWindowCount;
        localJBEWindow.setResizable(false);
        localJBEWindow.setVisible(true);
        this.waitForWindowActive(localJBEWindow);
        if (!visible) {
            localJBEWindow.setVisible(false);
        }
    }

    public void deleteWindow(String paramString) {
        this.windowTable.remove(paramString);
    }

    public void defineGObject(String paramString, GObject paramGObject) {
        this.gobjTable.put(paramString, paramGObject);
    }

    public void defineSource(JComponent paramJComponent, String paramString) {
        this.sourceTable.put(paramJComponent, paramString);
    }

    public void deleteGObject(String paramString) {
        this.gobjTable.remove(paramString);
    }

    protected String getSourceId(JComponent paramJComponent) {
        return this.sourceTable.get(paramJComponent);
    }

    public GObject getGObject(String paramString) {
        return this.gobjTable.get(paramString);
    }

    public JComponent getInteractor(GObject paramGObject) {
        if (paramGObject instanceof GInteractor) {
            return ((GInteractor)paramGObject).getInteractor();
        }
        if (paramGObject instanceof JBELabel) {
            return ((JBELabel)paramGObject).getInteractor();
        }
        return null;
    }

    public JBEWindow getWindow(String paramString) {
        return this.windowTable.get(paramString);
    }

    public void clearConsole() {
        this.console.clear();
    }

    public void setConsoleCloseOperation(int op) {
        this.consoleCloseOperation = op;
    }

    public void setConsoleFont(String paramString) {
        this.console.setFont(JTFTools.decodeFont(paramString));
    }

    public void consoleMinimize() {
        if (this.consoleFrame != null) {
            this.consoleFrame.setState(1);
        }
    }

    public void consoleToFront() {
        if (this.consoleFrame != null) {
            this.consoleFrame.setState(0);
            this.consoleFrame.toFront();
        }
    }

    public void consoleSetTitle(String title) {
        this.consoleWindowTitle = title;
        if (this.consoleFrame != null) {
            this.consoleFrame.setTitle(title);
        }
    }

    public void setConsoleSize(int paramInt1, int paramInt2) {
        this.consoleWidth = paramInt1;
        this.consoleHeight = paramInt2;
    }

    public void setConsoleLocation(int x, int y) {
        this.consoleX = x;
        this.consoleY = y;
        if (this.consoleFrame != null) {
            this.consoleFrame.setLocation(this.consoleX, this.consoleY);
        }
    }

    public String getConsole() {
        if (this.consoleFrame == null) {
            this.showConsole();
        }
        return this.console.readLine();
    }

    protected void putConsole(String paramString) {
        this.putConsole(paramString, false);
    }

    public void putConsole(String paramString, boolean isStderr) {
        if (this.consoleFrame == null) {
            this.showConsole();
        }
        if (isStderr) {
            ConsoleModel model = this.console.getConsoleModel();
            model.print(paramString, 2);
        } else {
            this.console.print(paramString);
        }
    }

    protected void endLineConsole() {
        this.endLineConsole(false);
    }

    protected void endLineConsole(boolean isStderr) {
        if (this.consoleFrame == null) {
            this.showConsole();
        }
        this.console.println();
    }

    protected double getEventTime() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String paramString) {
        Object object = this.eventLock;
        synchronized (object) {
            System.out.println(paramString);
            System.out.flush();
        }
    }

    protected void acknowledgeEvent(String eventText, Object ... args) {
        this.acknowledgeEvent(String.format(Locale.US, eventText, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeEvent(String eventText) {
        Object object = this.eventLock;
        synchronized (object) {
            System.out.println(eventText);
            System.out.flush();
            if (!this.eventAcknowledged) {
                System.out.println("result:___jbe___ack___ " + eventText);
                System.out.flush();
                this.eventAcknowledged = true;
                this.eventPending = false;
            } else {
                this.eventPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acknowledgeEvent() {
        Object object = this.eventLock;
        synchronized (object) {
            if (!this.eventAcknowledged) {
                System.out.println("result:___jbe___ack___");
                System.out.flush();
                this.eventAcknowledged = true;
                this.eventPending = false;
            } else {
                this.eventPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getNextEvent(int paramInt) {
        Object object = this.eventLock;
        synchronized (object) {
            this.eventAcknowledged = false;
            this.eventPending = false;
            this.acknowledgeEvent();
            this.eventMask = paramInt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForEvent(int paramInt) {
        Object object = this.eventLock;
        synchronized (object) {
            this.eventAcknowledged = false;
            if (this.eventPending) {
                this.acknowledgeEvent();
            }
            this.eventMask = paramInt;
        }
    }

    private void showConsole() {
        this.console.setPreferredSize(this.consoleWidth, this.consoleHeight);
        this.consoleFrame = new JFrame(this.consoleWindowTitle);
        this.consoleFrame.setDefaultCloseOperation(0);
        this.consoleFrame.setLayout(new BorderLayout());
        this.consoleFrame.add(this.console);
        this.consoleFrame.pack();
        this.consoleFrame.setLocation(this.consoleX, this.consoleY);
        this.consoleFrame.addWindowListener(this);
        if (Platform.isMac()) {
            this.menuBar.install(this.consoleFrame);
        } else {
            this.consoleFrame.setJMenuBar(this.menuBar);
        }
        this.consoleFrame.setVisible(true);
        this.waitForWindowActive(this.consoleFrame);
        ++this.activeWindowCount;
    }

    protected void createSound(String paramString1, String paramString2) {
        Clip localClip = this.getClip(paramString2);
        this.clipIdTable.put(paramString1, localClip);
    }

    protected void deleteSound(String paramString) {
        this.clipIdTable.remove(paramString);
    }

    protected void playSound(String paramString) {
        Clip localClip = this.clipIdTable.get(paramString);
        if (localClip != null) {
            localClip.stop();
            localClip.setFramePosition(0);
            localClip.start();
        }
    }

    protected void createTimer(String paramString, double paramDouble) {
        GTimer localGTimer = new GTimer(paramString, paramDouble);
        localGTimer.addActionListener(this);
        this.timerTable.put(paramString, localGTimer);
    }

    protected void deleteTimer(String paramString) {
        GTimer localGTimer = this.timerTable.get(paramString);
        if (localGTimer != null) {
            localGTimer.stop();
        }
        this.timerTable.remove(paramString);
    }

    protected void startTimer(String paramString) {
        GTimer localGTimer = this.timerTable.get(paramString);
        if (localGTimer != null) {
            localGTimer.start();
        }
    }

    protected void stopTimer(String paramString) {
        GTimer localGTimer = this.timerTable.get(paramString);
        if (localGTimer != null) {
            localGTimer.stop();
        }
    }

    private int convertModifiers(int paramInt) {
        int i = 0;
        if ((paramInt & 0x40) != 0) {
            i |= 1;
        }
        if ((paramInt & 0x80) != 0) {
            i |= 2;
        }
        if ((paramInt & 0x100) != 0) {
            i |= 4;
        }
        if ((paramInt & 0x200) != 0) {
            i |= 8;
        }
        if ((paramInt & 0x2000) != 0) {
            i |= 0x10;
        }
        if ((paramInt & 0x400) != 0) {
            i |= 0x20;
        }
        if ((paramInt & 0x800) != 0) {
            i |= 0x40;
        }
        if ((paramInt & 0x1000) != 0) {
            i |= 0x80;
        }
        return i;
    }

    public String openFileDialog(String title, String mode, String path) {
        if (path == null) {
            path = "";
        }
        JBEFileFilter localJBEFileFilter = new JBEFileFilter(path);
        JFileChooser localJFileChooser = new JFileChooser(localJBEFileFilter.getDirectory());
        localJFileChooser.setFileFilter(localJBEFileFilter);
        localJFileChooser.setDialogTitle(title);
        int result = 0;
        JBEConsole parent = null;
        if (this.console != null) {
            parent = this.console;
        }
        if (mode.equalsIgnoreCase("load")) {
            result = localJFileChooser.showOpenDialog(parent);
        } else if (mode.equalsIgnoreCase("save")) {
            result = localJFileChooser.showSaveDialog(parent);
        } else {
            return "";
        }
        if (result == 0) {
            return localJFileChooser.getSelectedFile().getAbsolutePath();
        }
        return "";
    }

    public void actionPerformed(ActionEvent paramActionEvent) {
        String localObject2;
        GInteractor localGInteractor;
        String str;
        Object localObject1 = paramActionEvent.getSource();
        if (localObject1 instanceof GTimer) {
            if ((this.eventMask & 0x40) != 0) {
                GTimer localObject22 = (GTimer)paramActionEvent.getSource();
                this.acknowledgeEvent("event:timerTicked(\"%s\", %d)", localObject22.getId(), (long)this.getEventTime());
            }
        } else if ((this.eventMask & 0x10) != 0 && !(str = (localGInteractor = (GInteractor)this.getGObject(localObject2 = this.getSourceId((JComponent)localObject1))).getActionCommand()).isEmpty()) {
            this.acknowledgeEvent("event:actionPerformed(\"%s\", \"%s\", %d)", localObject2, str, (long)this.getEventTime());
        }
    }

    public void keyPressed(KeyEvent paramKeyEvent) {
        if ((this.eventMask & 0x20) != 0) {
            this.printEvent("keyPressed", paramKeyEvent);
        }
    }

    public void keyReleased(KeyEvent paramKeyEvent) {
        if ((this.eventMask & 0x20) != 0) {
            this.printEvent("keyReleased", paramKeyEvent);
        }
    }

    public void keyTyped(KeyEvent paramKeyEvent) {
        if ((this.eventMask & 0x20) != 0) {
            this.printEvent("keyTyped", paramKeyEvent);
        }
    }

    private void printEvent(String type, KeyEvent paramKeyEvent) {
        JBECanvas localJBECanvas = (JBECanvas)paramKeyEvent.getSource();
        this.acknowledgeEvent("event:%s(\"%s\", %d, %d, %s, %d)", type, localJBECanvas.getWindowId(), (long)this.getEventTime(), this.convertModifiers(paramKeyEvent.getModifiersEx()), Character.valueOf(paramKeyEvent.getKeyChar()), paramKeyEvent.getKeyCode());
    }

    public void mouseClicked(MouseEvent paramMouseEvent) {
        ((Component)paramMouseEvent.getSource()).requestFocus();
        if ((this.eventMask & 0x300) != 0) {
            this.printEvent("mouseClicked", paramMouseEvent);
        }
    }

    public void mouseEntered(MouseEvent paramMouseEvent) {
    }

    public void mouseExited(MouseEvent paramMouseEvent) {
    }

    public void mousePressed(MouseEvent paramMouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mousePressed", paramMouseEvent);
        }
    }

    public void mouseReleased(MouseEvent paramMouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mouseReleased", paramMouseEvent);
        }
    }

    public void mouseMoved(MouseEvent paramMouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mouseMoved", paramMouseEvent);
        }
    }

    public void mouseDragged(MouseEvent paramMouseEvent) {
        if ((this.eventMask & 0x100) != 0) {
            this.printEvent("mouseDragged", paramMouseEvent);
        }
    }

    private void printEvent(String type, MouseEvent paramMouseEvent) {
        JBECanvas localJBECanvas = (JBECanvas)paramMouseEvent.getSource();
        this.acknowledgeEvent("event:%s(\"%s\", %d, %d, %d, %d)", type, localJBECanvas.getWindowId(), (long)this.getEventTime(), this.convertModifiers(paramMouseEvent.getModifiersEx()), paramMouseEvent.getX(), paramMouseEvent.getY());
    }

    public void windowActivated(WindowEvent paramWindowEvent) {
    }

    public void windowClosed(WindowEvent paramWindowEvent) {
        this.windowClosing(paramWindowEvent);
    }

    public void shutdownBackEnd(boolean sendEvent) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    System.out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    System.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        }).start();
        if (sendEvent) {
            if (this.consoleFrame != null) {
                this.consoleFrame.setVisible(false);
            }
            this.acknowledgeEvent("event:lastWindowGWindow_closed()");
            this.acknowledgeEvent("event:consoleWindowClosed()");
        }
    }

    public void windowClosing(WindowEvent paramWindowEvent) {
        if (paramWindowEvent.getSource() == this.consoleFrame) {
            if (this.consoleCloseOperation == 0) {
                return;
            }
            if (this.consoleCloseOperation == 3) {
                this.shutdownBackEnd(false);
            } else if (this.consoleCloseOperation == 1) {
                this.consoleFrame.setVisible(false);
            }
            this.acknowledgeEvent("event:consoleWindowClosed()");
        } else {
            JBEWindow localJBEWindow = (JBEWindow)paramWindowEvent.getSource();
            if (this.windowTable.containsKey(localJBEWindow.getWindowId())) {
                this.acknowledgeEvent("event:windowClosed(\"%s\", %d)", localJBEWindow.getWindowId(), (long)this.getEventTime());
                this.windowTable.remove(localJBEWindow.getWindowId());
            }
        }
        --this.activeWindowCount;
        if (this.activeWindowCount == 0) {
            this.acknowledgeEvent("event:lastWindowGWindow_closed()");
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent paramWindowEvent) {
    }

    public void windowDeiconified(WindowEvent paramWindowEvent) {
    }

    public void windowIconified(WindowEvent paramWindowEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowOpened(WindowEvent paramWindowEvent) {
        JFrame localJFrame;
        JFrame jFrame = localJFrame = (JFrame)paramWindowEvent.getSource();
        synchronized (jFrame) {
            localJFrame.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForWindowActive(JFrame paramJFrame) {
        JFrame jFrame = paramJFrame;
        synchronized (jFrame) {
            while (true) {
                if (paramJFrame.isShowing()) {
                    return;
                }
                try {
                    paramJFrame.wait();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stateChanged(ChangeEvent paramChangeEvent) {
        String str1;
        GInteractor localGInteractor;
        String str2;
        Object localObject1 = paramChangeEvent.getSource();
        if ((this.eventMask & 0x10) != 0 && !(str2 = (localGInteractor = (GInteractor)this.getGObject(str1 = this.getSourceId((JComponent)localObject1))).getActionCommand()).isEmpty()) {
            this.acknowledgeEvent("event:actionPerformed(\"%s\", \"%s\", %d)", str1, str2, (long)this.getEventTime());
        }
    }

    public void componentHidden(ComponentEvent paramComponentEvent) {
    }

    public void componentMoved(ComponentEvent paramComponentEvent) {
    }

    public void componentResized(ComponentEvent paramComponentEvent) {
        if ((this.eventMask & 0x80) != 0) {
            JBECanvas localJBECanvas = (JBECanvas)paramComponentEvent.getSource();
            this.acknowledgeEvent("event:windowResized(\"%s\", %d)", localJBECanvas.getWindowId(), (long)this.getEventTime());
        }
    }

    public void componentShown(ComponentEvent paramComponentEvent) {
    }

    private void printLog(String s) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(DEBUG_LOG_FILE, true));
            out.println(s);
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void commandLoop() {
        block6: {
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(System.in));
            TokenScanner localTokenScanner = new TokenScanner();
            localTokenScanner.ignoreWhitespace();
            localTokenScanner.scanNumbers();
            localTokenScanner.scanStrings();
            localTokenScanner.addWordCharacters(".");
            try {
                String str1;
                while ((str1 = localBufferedReader.readLine()) != null) {
                    if (DEBUG) {
                        this.printLog(str1);
                    }
                    if (str1.equals("LongCommand.begin()")) {
                        str1 = this.readLongCommand(localBufferedReader);
                    }
                    localTokenScanner.setInput(str1);
                    String str2 = localTokenScanner.nextToken();
                    JBECommand localJBECommand = this.cmdTable.get(str2);
                    if (localJBECommand == null) {
                        System.err.println("Unexpected error: unknown command \"" + str2 + "\"");
                        continue;
                    }
                    localJBECommand.execute(localTokenScanner, this);
                }
            }
            catch (Exception localException) {
                localException.printStackTrace(System.err);
                System.err.println("Unexpected error: " + localException.getMessage());
                if (!DEBUG) break block6;
                this.printLog("Unexpected error: " + localException.getMessage());
            }
        }
    }

    private String readLongCommand(BufferedReader systemInReader) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder(65536);
        while ((line = systemInReader.readLine()) != null && !line.equals("LongCommand.end()")) {
            sb.append(line);
        }
        String cmd = sb.toString();
        return cmd;
    }

    private void processArguments(String[] paramArrayOfString) {
        this.appName = "JBE";
        this.exec = null;
        int i = 0;
        while (i < paramArrayOfString.length) {
            String str = paramArrayOfString[i];
            if (str.startsWith("-")) {
                if (str.equals("-exec")) {
                    this.exec = paramArrayOfString[++i];
                } else {
                    System.err.println("Error: Unrecognized option " + str);
                }
            } else {
                this.appName = str;
            }
            ++i;
        }
    }

    private void initSystemProperties() {
        block5: {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.appName);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            try {
                UIManager.put("Slider.paintValue", false);
                try {
                    String lnf = UIManager.getSystemLookAndFeelClassName();
                    if (lnf == null || lnf.contains("MetalLookAndFeel")) {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                        break block5;
                    }
                    UIManager.setLookAndFeel(lnf);
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Image getImage(String paramString) {
        Serializable localObject;
        Image localImage = this.imageTable.get(paramString);
        if (localImage != null) {
            return localImage;
        }
        Toolkit localToolkit = Toolkit.getDefaultToolkit();
        if (paramString.startsWith("http:")) {
            try {
                localImage = localToolkit.getImage(new URL(paramString));
            }
            catch (MalformedURLException localMalformedURLException) {
                throw new ErrorException("loadImage: Malformed URL");
            }
        } else {
            localObject = new File(paramString);
            if (!(localObject.exists() || paramString.startsWith("/") || paramString.startsWith("."))) {
                localObject = new File("images/" + paramString);
            }
            if (!localObject.exists()) {
                throw new ErrorException("loadImage: File not found");
            }
            localImage = localToolkit.getImage(localObject.getAbsolutePath());
        }
        if (localImage == null) {
            throw new ErrorException("loadImage: File not found");
        }
        localObject = new MediaTracker(this.empty);
        ((MediaTracker)localObject).addImage(localImage, 0);
        try {
            ((MediaTracker)localObject).waitForID(0);
        }
        catch (InterruptedException localInterruptedException) {
            throw new ErrorException("loadImage: Loading interrupted");
        }
        this.imageTable.put(paramString, localImage);
        return localImage;
    }

    protected Clip getClip(String paramString) {
        Clip localClip = this.clipTable.get(paramString);
        if (localClip != null) {
            return localClip;
        }
        try {
            localClip = AudioSystem.getClip();
            File localFile = new File(paramString);
            if (!(localFile.exists() || paramString.startsWith("/") || paramString.startsWith("."))) {
                localFile = new File("sounds/" + paramString);
            }
            if (!localFile.exists()) {
                throw new ErrorException("createClip: File not found");
            }
            BufferedInputStream localFileInputStream = new BufferedInputStream(new FileInputStream(localFile));
            AudioInputStream localAudioInputStream = AudioSystem.getAudioInputStream(localFileInputStream);
            localClip.open(localAudioInputStream);
        }
        catch (IOException localIOException) {
            throw new ErrorException("getClip: I/O error (" + new File(paramString).getAbsolutePath() + ")");
        }
        catch (Exception localException) {
            throw new ErrorException("getClip: " + localException);
        }
        this.clipTable.put(paramString, localClip);
        return localClip;
    }

    public KeyListener getConsoleKeyListener() {
        ConsoleModel consoleModel = this.console.getConsoleModel();
        if (consoleModel != null) {
            return (KeyListener)((Object)consoleModel);
        }
        return null;
    }
}

