/*
 * Decompiled with CFR 0.152.
 */
package stanford.karel;

import acm.util.JTFTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import stanford.karel.CardPanel;
import stanford.karel.HPanel;
import stanford.karel.Karel;
import stanford.karel.KarelProgram;
import stanford.karel.KarelResizer;
import stanford.karel.KarelWorld;
import stanford.karel.KarelWorldEditor;
import stanford.karel.KarelWorldMonitor;
import stanford.karel.LoadWorldDialog;
import stanford.karel.NewWorldDialog;
import stanford.karel.VPanel;

public class KarelControlPanel
extends CardPanel
implements KarelWorldMonitor,
ActionListener,
AdjustmentListener,
ChangeListener,
Observer {
    private static final double SPEED_SCALE_FACTOR = 100.0;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 18;
    private static final int BUTTON_SEP = 8;
    private static final int SMALL_BUTTON_WIDTH = 60;
    private static final int GAP = 5;
    private static final double SLOW_DELAY = 200.0;
    private static final double FAST_DELAY = 0.0;
    private KarelProgram program;
    private KarelWorld world;
    private KarelWorldEditor editor;
    private KarelResizer resizer;
    private JComponent buttonPanel;
    private JComponent editorPanel;
    private JComponent resizePanel;
    private JButton startButton;
    private JButton resetButton;
    private JButton loadWorldButton;
    private JButton newWorldButton;
    private JButton editWorldButton;
    private JButton saveWorldButton;
    private JButton dontSaveButton;
    private JButton okButton;
    private JButton cancelButton;
    private JSlider speedBar;
    private double speed;

    public KarelControlPanel(KarelProgram program) {
        this.program = program;
        program.StateEvent.add(this);
        this.world = program.getWorld();
        this.editor = this.createEditor();
        this.resizer = this.createResizer();
        this.editorPanel = this.createEditorPanel();
        this.add("editor", this.editorPanel);
        this.resizePanel = this.createResizePanel();
        this.add("resize", this.resizePanel);
        this.buttonPanel = this.createButtonPanel();
        this.add("buttons", this.buttonPanel);
        this.setView("buttons");
        this.setSpeed(0.0);
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    public KarelProgram getProgram() {
        return this.program;
    }

    public KarelWorldEditor getEditor() {
        return this.editor;
    }

    public KarelResizer getResizer() {
        return this.resizer;
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 1);
    }

    public void startWorldEdit() {
    }

    public void endWorldEdit() {
    }

    public void wallAction(Point pt, int dir) {
        this.editor.wallAction(pt, dir);
    }

    public void cornerAction(Point pt) {
        this.editor.cornerAction(pt);
    }

    public void trace() {
        double delay = this.speed == -2.0 ? 1000.0 : (this.speed == -1.0 ? 500.0 : 200.0 + Math.sqrt(this.speed) * -200.0);
        if (this.speed < 0.98) {
            JTFTools.pause(delay);
        }
    }

    public void setSpeed(double speed) {
        this.speed = speed;
        int value = (int)Math.round(100.0 * speed);
        this.speedBar.setValue(value + 20);
    }

    public double getSpeed() {
        return this.speed;
    }

    protected KarelWorldEditor createEditor() {
        return new KarelWorldEditor(this.getWorld());
    }

    protected JComponent createEditorPanel() {
        VPanel vbox = new VPanel();
        vbox.add("", this.editor);
        this.saveWorldButton = new JButton("Save World");
        this.saveWorldButton.setMnemonic('S');
        this.saveWorldButton.addActionListener(this);
        vbox.add("/width:100/height:18/top:8", this.saveWorldButton);
        this.dontSaveButton = new JButton("Don't Save");
        this.dontSaveButton.setMnemonic('D');
        this.dontSaveButton.addActionListener(this);
        vbox.add("/width:100/height:18/top:8", this.dontSaveButton);
        return vbox;
    }

    protected JComponent createButtonPanel() {
        JButton button;
        VPanel vPanel = new VPanel();
        this.startButton = new JButton("Start Program");
        this.startButton.setMnemonic('S');
        this.startButton.addActionListener(this);
        this.resetButton = new JButton("Reset Program");
        this.resetButton.setMnemonic('R');
        this.resetButton.addActionListener(this);
        this.loadWorldButton = new JButton("Load World");
        this.loadWorldButton.setMnemonic('L');
        this.loadWorldButton.addActionListener(this);
        this.newWorldButton = new JButton("New World");
        this.newWorldButton.setMnemonic('N');
        this.newWorldButton.addActionListener(this);
        this.editWorldButton = new JButton("Edit World");
        this.editWorldButton.setMnemonic('E');
        this.editWorldButton.addActionListener(this);
        JButton[] buttons = new JButton[]{this.startButton, this.resetButton, this.loadWorldButton, this.newWorldButton, this.editWorldButton};
        int maxWidth = 0;
        JButton[] jButtonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            button = jButtonArray[n2];
            maxWidth = Math.max(maxWidth, button.getPreferredSize().width);
            ++n2;
        }
        jButtonArray = buttons;
        n = buttons.length;
        n2 = 0;
        while (n2 < n) {
            button = jButtonArray[n2];
            button.setPreferredSize(new Dimension(maxWidth, button.getPreferredSize().height));
            button.setMinimumSize(new Dimension(maxWidth, button.getPreferredSize().height));
            ++n2;
        }
        vPanel.add("/center/width:100/height:18", this.startButton);
        vPanel.add("/center/width:100/height:18/top:8", this.resetButton);
        vPanel.add("/center/width:100/height:18/top:8", this.loadWorldButton);
        vPanel.add("/center/width:100/height:18/top:8", this.newWorldButton);
        vPanel.add("/center/width:100/height:18/top:8", this.editWorldButton);
        HPanel hPanel = new HPanel();
        this.speedBar = new JSlider(0);
        this.speedBar.addChangeListener(this);
        this.speedBar.setMaximum(0);
        this.speedBar.setMaximum(120);
        this.speedBar.setValue(20);
        this.speedBar.setMajorTickSpacing(60);
        this.speedBar.setMinorTickSpacing(10);
        this.speedBar.setSnapToTicks(true);
        this.speedBar.setPaintTicks(true);
        this.speedBar.setPaintTrack(true);
        hPanel.add("/center", new Label("Slow "));
        hPanel.add("/center/width:100", this.speedBar);
        hPanel.add("/center", new Label(" Fast"));
        vPanel.add("/center/top:8", hPanel);
        return vPanel;
    }

    protected JComponent createResizePanel() {
        VPanel vbox = new VPanel();
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        vbox.add("", this.getResizer());
        vbox.add("/center/width:60/space:5", this.okButton);
        vbox.add("/center/width:60/space:5", this.cancelButton);
        return vbox;
    }

    protected KarelResizer createResizer() {
        return new KarelResizer();
    }

    public void actionPerformed(ActionEvent e) {
        Component source = (Component)e.getSource();
        if (source == this.startButton) {
            this.program.setStatus("Running ...");
            this.program.signalStarted();
        } else if (source == this.resetButton) {
            String filePath = this.world.getPathName();
            System.out.println("filePath = " + filePath);
            if (filePath != null) {
                this.world.load(filePath);
                this.program.setStatus("Loaded world from " + new File(filePath).getName() + ".");
            }
        } else if (source == this.loadWorldButton) {
            LoadWorldDialog dialog = new LoadWorldDialog(this.world);
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            if (fileName != null) {
                this.world.load(String.valueOf(dialog.getDirectory()) + "/" + fileName);
                this.program.setStatus("Loaded world from " + fileName + ".");
            }
        } else if (source == this.newWorldButton) {
            this.setView("resize");
        } else if (source == this.editWorldButton) {
            this.world.setEditMode(true);
            this.editor.initEditorCanvas();
            this.setView("editor");
        } else if (source == this.saveWorldButton) {
            if (this.world.getPathname() == null) {
                NewWorldDialog dialog = new NewWorldDialog(this.world);
                dialog.setVisible(true);
                String fileName = dialog.getFile();
                if (fileName != null) {
                    this.world.setPathName(String.valueOf(dialog.getDirectory()) + "/" + fileName);
                    this.program.setStatus("Saved world to " + fileName + ".");
                }
            }
            this.world.save();
            this.world.setEditMode(false);
            this.setView("buttons");
        } else if (source == this.dontSaveButton) {
            this.world.setEditMode(false);
            this.setView("buttons");
        } else if (source == this.cancelButton) {
            this.setView("buttons");
        } else if (source == this.okButton) {
            NewWorldDialog dialog = new NewWorldDialog(this.world);
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            if (fileName == null) {
                this.setView("buttons");
            } else {
                this.world.init(this.resizer.getColumns(), this.resizer.getRows());
                this.world.setPathName(String.valueOf(dialog.getDirectory()) + "/" + fileName);
                this.world.setEditMode(true);
                if (this.world.getKarelCount() == 1) {
                    Karel karel = this.world.getKarel();
                    karel.setLocation(1, 1);
                    karel.setDirection(1);
                    karel.setBeepersInBag(99999999);
                    this.world.repaint();
                }
                this.editor.initEditorCanvas();
                this.setView("editor");
            }
        }
        this.doEnabling();
    }

    private void doEnabling() {
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        Component source = (Component)e.getSource();
        if (source == this.speedBar) {
            this.updateSpeed();
        }
    }

    public void stateChanged(ChangeEvent e) {
        Component source = (Component)e.getSource();
        if (source == this.speedBar) {
            this.updateSpeed();
        }
    }

    public void update(Observable obs, Object arg) {
        boolean running = arg == KarelProgram.State.RUNNING;
        this.startButton.setEnabled(!running);
        this.resetButton.setEnabled(!running);
        this.loadWorldButton.setEnabled(!running);
        this.newWorldButton.setEnabled(!running);
        this.editWorldButton.setEnabled(!running);
    }

    private void updateSpeed() {
        int value = this.speedBar.getValue();
        this.speed = value == 0 ? -2.0 : (value == 10 ? -1.0 : (double)(value - 20) / 100.0);
    }
}

