/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;

public class GOval
extends GObject
implements GFillable,
GResizable {
    private double frameWidth;
    private double frameHeight;
    private boolean isFilled;
    private Color fillColor;
    static final long serialVersionUID = 21L;

    public GOval(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public GOval(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public GRectangle getBounds() {
        Shape shape = new Ellipse2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight);
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        Rectangle rectangle = shape.getBounds();
        return new GRectangle(((RectangularShape)rectangle).getX() + this.getX(), ((RectangularShape)rectangle).getY() + this.getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
    }

    public boolean contains(double d, double d2) {
        RectangularShape rectangularShape = new Ellipse2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight);
        AffineTransform affineTransform = this.getMatrix();
        if (affineTransform != null) {
            rectangularShape = affineTransform.createTransformedShape(rectangularShape).getBounds();
        }
        return rectangularShape.contains(d - this.getX(), d2 - this.getY());
    }

    protected void paint2d(Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, this.frameWidth, this.frameHeight);
        if (this.isFilled()) {
            graphics2D.setColor(this.getFillColor());
            graphics2D.fill(double_);
            graphics2D.setColor(this.getColor());
        }
        graphics2D.draw(double_);
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public void setSize(double d, double d2) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setSize: Object has been transformed");
        }
        this.frameWidth = d;
        this.frameHeight = d2;
        this.repaint();
    }

    public final void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.frameWidth, this.frameHeight);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setBounds: Object has been transformed");
        }
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public final void setBounds(GRectangle gRectangle) {
        if (this.getMatrix() != null) {
            throw new ErrorException("setBounds: Object has been transformed");
        }
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }
}

