/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.mpeg.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.spi.mpeg.sampled.convert.DecodedMpegAudioInputStream;
import javazoom.spi.mpeg.sampled.file.MpegEncoding;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;

public class MpegFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final AudioFormat.Encoding MP3 = Encodings.getEncoding("MP3");
    private static final AudioFormat.Encoding PCM_SIGNED = Encodings.getEncoding("PCM_SIGNED");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MP3, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MP3, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MP3, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MP3, -1.0f, -1, 2, -1, -1.0f, true)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true)};

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">MpegFormatConversionProvider()");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">MpegFormatConversionProvider.getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream):");
        }
        return new DecodedMpegAudioInputStream(audioFormat, audioInputStream);
    }

    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        AudioFormat.Encoding encoding;
        boolean bl;
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">MpegFormatConversionProvider.isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + audioFormat2);
            TDebug.out("to: " + audioFormat);
        }
        if (!(bl = super.isConversionSupported(audioFormat, audioFormat2)) && (encoding = audioFormat2.getEncoding()) instanceof MpegEncoding && (audioFormat2.getFrameRate() != -1.0f || audioFormat2.getFrameSize() != -1)) {
            bl = true;
        }
        return bl;
    }
}

