/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import stanford.cs106.collections.Edge;
import stanford.cs106.collections.Graph;
import stanford.cs106.collections.Table;
import stanford.cs106.collections.TreeBasedTable;
import stanford.cs106.collections.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGraph
implements Graph {
    private boolean directed;
    private boolean weighted;
    private Table<Vertex, Vertex, Edge> adjacencyMap;
    private Map<String, Vertex> vertexes;

    public BasicGraph() {
        this(false, false);
    }

    public BasicGraph(boolean directed, boolean weighted) {
        this.directed = directed;
        this.weighted = weighted;
        this.adjacencyMap = TreeBasedTable.create();
        this.vertexes = new TreeMap<String, Vertex>();
    }

    @Override
    public final void addEdge(String v1, String v2) {
        this.addEdge(v1, v2, 1.0);
    }

    @Override
    public final void addEdge(String v1, String v2, double weight) {
        this.addEdge(this.vertex(v1), this.vertex(v2), weight);
    }

    @Override
    public final void addEdge(Vertex v1, Vertex v2) {
        this.addEdge(v1, v2, 1.0);
    }

    @Override
    public final void addEdge(Vertex v1, Vertex v2, double weight) {
        this.checkVertexes(v1, v2);
        BasicGraph.checkForNegative(weight);
        if (v1.equals(v2)) {
            throw new IllegalArgumentException("Cannot add a loop (an edge from " + v1 + " back to itself)");
        }
        if (!this.weighted && weight != 1.0) {
            throw new IllegalArgumentException("Unweighted graph cannot accept edge weight of " + weight + " (must be " + 1 + ")");
        }
        Edge edge = null;
        if (this.containsEdge(v1, v2)) {
            edge = this.edge(v1, v2);
            edge.setWeight(weight);
        } else {
            edge = this.weighted ? new Edge(v1, v2, weight) : new Edge(v1, v2);
            this.adjacencyMap.put(v1, v2, edge);
            if (!this.directed) {
                this.adjacencyMap.put(v2, v1, edge);
            }
        }
    }

    @Override
    public final void addVertex(String v) {
        BasicGraph.checkForNull(v);
        if (!this.containsVertex(v)) {
            this.vertexes.put(v, new Vertex(v));
        }
    }

    @Override
    public final void clear() {
        this.vertexes.clear();
        this.clearEdges();
    }

    @Override
    public final void clearEdges() {
        this.adjacencyMap.clear();
    }

    @Override
    public final boolean containsEdge(String v1, String v2) {
        return this.containsEdge(this.vertex(v1), this.vertex(v2));
    }

    @Override
    public final boolean containsEdge(Vertex v1, Vertex v2) {
        return this.adjacencyMap.contains(v1, v2) || !this.directed && this.adjacencyMap.contains(v2, v1);
    }

    @Override
    public final boolean containsPath(List<String> path) {
        BasicGraph.checkForNull(path);
        Iterator<String> itr = path.iterator();
        String prev = null;
        while (itr.hasNext()) {
            String next = itr.next();
            if (!this.containsVertex(next) || prev != null && !this.containsEdge(prev, next)) {
                return false;
            }
            prev = next;
        }
        return true;
    }

    @Override
    public final boolean containsVertex(String v) {
        return this.vertexes.containsKey(v);
    }

    @Override
    public final boolean containsVertex(Vertex v) {
        return this.vertexes.containsKey(v.name());
    }

    @Override
    public final double cost(List<String> path) {
        BasicGraph.checkForNull(path);
        if (path.isEmpty()) {
            return 0.0;
        }
        int totalCost = 0;
        String prev = null;
        for (String v : path) {
            BasicGraph.checkForNull(v);
            this.checkVertex(v);
            if (prev != null) {
                double weight = this.edgeWeight(prev, v);
                if (weight < 0.0) {
                    throw new IllegalArgumentException("no edge between " + prev + " and " + v);
                }
                totalCost = (int)((double)totalCost + weight);
            }
            prev = v;
        }
        return totalCost;
    }

    @Override
    public final int degree(String v) {
        return this.outDegree(v);
    }

    @Override
    public final int degree(Vertex v) {
        return this.outDegree(v);
    }

    @Override
    public final Edge edge(String v1, String v2) {
        return this.edge(this.vertex(v1), this.vertex(v2));
    }

    @Override
    public final Edge edge(Vertex v1, Vertex v2) {
        BasicGraph.checkForNull(v1, v2);
        this.checkVertexes(v1, v2);
        if (this.adjacencyMap.contains(v1, v2)) {
            return this.adjacencyMap.get(v1, v2);
        }
        return null;
    }

    @Override
    public final int edgeCount() {
        return this.edges().size();
    }

    @Override
    public final Collection<Edge> edges() {
        return this.adjacencyMap.values();
    }

    @Override
    public final double edgeWeight(String v1, String v2) {
        return this.edgeWeight(this.vertex(v1), this.vertex(v2));
    }

    @Override
    public final double edgeWeight(Vertex v1, Vertex v2) {
        if (this.containsEdge(v1, v2)) {
            return this.edge(v1, v2).weight();
        }
        return -1.0;
    }

    public boolean equals(Object o) {
        if (o instanceof BasicGraph) {
            BasicGraph other = (BasicGraph)o;
            return this.directed == other.directed && this.weighted == other.weighted && this.adjacencyMap.equals(other.adjacencyMap) && this.vertexes.equals(other.vertexes);
        }
        return false;
    }

    public int hashCode() {
        return 13 * Boolean.valueOf(this.directed).hashCode() + 37 * Boolean.valueOf(this.weighted).hashCode() + 51 * this.adjacencyMap.hashCode() + 117 * this.vertexes.hashCode();
    }

    @Override
    public final int inDegree(String v) {
        return this.inDegree(this.vertex(v));
    }

    @Override
    public final int inDegree(Vertex v) {
        this.checkVertex(v);
        if (this.adjacencyMap.containsColumn(v)) {
            return this.adjacencyMap.column(v).size();
        }
        return 0;
    }

    @Override
    public final boolean isDirected() {
        return this.directed;
    }

    @Override
    public final boolean isEmpty() {
        return this.vertexes.isEmpty();
    }

    @Override
    public final boolean isWeighted() {
        return this.weighted;
    }

    @Override
    public final Set<Vertex> neighbors(String v) {
        return this.neighbors(this.vertex(v));
    }

    @Override
    public final Set<Vertex> neighbors(Vertex v) {
        this.checkVertex(v);
        if (this.adjacencyMap.containsRow(v)) {
            return this.adjacencyMap.row(v).keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public final int outDegree(String v) {
        return this.outDegree(this.vertex(v));
    }

    @Override
    public final int outDegree(Vertex v) {
        return this.neighbors(v).size();
    }

    @Override
    public final void removeEdge(Edge e) {
        this.removeEdge(e.start().name(), e.end().name());
    }

    @Override
    public final void removeEdge(String v1, String v2) {
        this.removeEdge(this.vertex(v1), this.vertex(v2));
    }

    @Override
    public final void removeEdge(Vertex v1, Vertex v2) {
        if (this.containsEdge(v1, v2)) {
            this.adjacencyMap.remove(v1, v2);
            if (!this.directed) {
                this.adjacencyMap.remove(v2, v1);
            }
        }
    }

    @Override
    public final void removeVertex(String v) {
        BasicGraph.checkForNull(v);
        if (this.containsVertex(v)) {
            this.removeVertexHelper(v);
            this.vertexes.remove(v);
        }
    }

    @Override
    public final void removeVertex(Vertex v) {
        BasicGraph.checkForNull(v);
        if (this.containsVertex(v)) {
            this.removeVertexHelper(v);
            this.vertexes.remove(v);
        }
    }

    @Override
    public final void resetData() {
        this.clearVertexInfo();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(65536);
        sb.append("{V={");
        boolean first = true;
        for (Vertex v : this.vertexes()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(v.name());
        }
        sb.append("}");
        sb.append(", E={");
        first = true;
        for (Edge e : this.adjacencyMap.values()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(e);
        }
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public final String toStringDetailed() {
        StringBuilder sb = new StringBuilder(65536);
        sb.append("Graph{\n").append("\tvertices:\n");
        for (Vertex v : this.vertexes()) {
            sb.append("\t\t").append(this.vertexes.get(v)).append(" -> neighbors: ").append(this.neighbors(v.name())).append('\n');
        }
        sb.append("\tedges:\n");
        for (Edge edge : this.adjacencyMap.values()) {
            sb.append("\t\t").append(edge).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Vertex vertex(String name) {
        return this.vertexes.get(name);
    }

    @Override
    public final int vertexCount() {
        return this.vertexes.size();
    }

    @Override
    public final Collection<Vertex> vertexes() {
        return this.vertexes.values();
    }

    protected static void checkForNegative(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("argument cannot be negative: " + value);
        }
    }

    protected static void checkForNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("argument cannot be negative: " + value);
        }
    }

    protected static void checkForNull(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                throw new NullPointerException("argument must not be null");
            }
            ++n2;
        }
    }

    protected final void checkVertex(String vertex) {
        BasicGraph.checkForNull(vertex);
        if (!this.containsVertex(vertex)) {
            throw new IllegalArgumentException("Vertex not found in graph: " + vertex);
        }
    }

    protected final void checkVertex(Vertex vertex) {
        BasicGraph.checkForNull(vertex);
        if (!this.containsVertex(vertex.name()) || this.vertex(vertex.name()) != vertex) {
            throw new IllegalArgumentException("Vertex not found in graph: " + vertex);
        }
    }

    protected final void checkVertexes(String v1, String v2) {
        this.checkVertex(v1);
        this.checkVertex(v2);
    }

    protected final void checkVertexes(Vertex v1, Vertex v2) {
        this.checkVertex(v1);
        this.checkVertex(v2);
    }

    protected final void clearVertexInfo() {
        for (Vertex vertex : this.vertexes.values()) {
            vertex.clear();
        }
    }

    protected final void corruptVertexInfo() {
        Random rand = new Random(42L);
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>(this.vertexes());
        Collections.shuffle(vertexList, rand);
        int i = 0;
        for (Vertex vertex : this.vertexes.values()) {
            if (i % 2 == 0) {
                vertex.setCost(rand.nextInt(1000));
                vertex.setNumber(rand.nextInt(1000000));
                int randomIndex = rand.nextInt(vertexList.size());
                vertex.setPrevious((Vertex)vertexList.get(randomIndex));
                continue;
            }
            vertex.clear();
        }
    }

    protected final Vertex vertexInfo(String v) {
        this.checkVertex(v);
        return this.vertexes.get(v);
    }

    protected final Map<String, Vertex> vertexInfos() {
        return Collections.unmodifiableMap(this.vertexes);
    }

    private void removeVertexHelper(String v) {
        Vertex vertex = this.vertex(v);
        Map<Vertex, Edge> row = this.adjacencyMap.row(vertex);
        row.clear();
        Map<Vertex, Edge> column = this.adjacencyMap.column(vertex);
        column.clear();
        this.vertexes.remove(v);
    }

    private void removeVertexHelper(Vertex v) {
        Map<Vertex, Edge> row = this.adjacencyMap.row(v);
        row.clear();
        Map<Vertex, Edge> column = this.adjacencyMap.column(v);
        column.clear();
        this.vertexes.remove(v.name());
    }
}

