/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.collections;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid<E> {
    private int rows;
    private int cols;
    private E[][] array;

    public Grid(int rows, int cols) {
        this.resize(rows, cols);
    }

    public void fill(E value) {
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                this.array[row][col] = value;
                ++col;
            }
            ++row;
        }
    }

    public E get(int row, int col) {
        this.checkIndex(row, col);
        return this.array[row][col];
    }

    public int height() {
        return this.rows;
    }

    public boolean inBounds(int row, int col) {
        return row >= 0 && row < this.rows && col >= 0 && col < this.cols;
    }

    public boolean isEmpty() {
        return this.rows == 0 || this.cols == 0;
    }

    public int numCols() {
        return this.cols;
    }

    public int numRows() {
        return this.rows;
    }

    public void resize(int rows, int cols) {
        if (rows < 0 || cols < 0) {
            throw new IllegalArgumentException(String.valueOf(rows) + "," + cols);
        }
        this.rows = rows;
        this.cols = cols;
        this.array = new Object[rows][cols];
    }

    public void set(int row, int col, E value) {
        this.checkIndex(row, col);
        this.array[row][col] = value;
    }

    public int size() {
        return this.rows * this.cols;
    }

    public String toString() {
        return Arrays.deepToString(this.array);
    }

    public int width() {
        return this.cols;
    }

    private void checkIndex(int row, int col) {
        if (!this.inBounds(row, col)) {
            throw new IndexOutOfBoundsException(String.valueOf(row) + "," + col);
        }
    }
}

