/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader source;

    public ReaderInputStream(Reader source) {
        this.source = source;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public void mark(int readAheadLimit) {
        try {
            this.source.mark(readAheadLimit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int read() throws IOException {
        return this.source.read();
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        char[] cbuf = new char[b.length];
        int result = this.source.read(cbuf, offset, length);
        int i = offset;
        while (i < offset + result) {
            b[i] = (byte)cbuf[i];
            ++i;
        }
        return result;
    }

    public void reset() throws IOException {
        this.source.reset();
    }

    public long skip(long n) throws IOException {
        return this.source.skip(n);
    }
}

