/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;

public class TranspositionCipher {
    static char PAD = (char)126;

    public static void main(String[] args) {
        new MainWindow();
        int encryptChoice = 1;
        while (encryptChoice > 0) {
            System.out.println("Welcome to the Transposition Cipher Machine!");
            System.out.println("Please choose:");
            System.out.println("1) encrypt text");
            System.out.println("2) decrypt text");
            while (true) {
                System.out.print("Please type your choice, 0 to end: ");
                System.out.flush();
                try {
                    encryptChoice = Integer.parseInt(Console.getLine());
                }
                catch (NumberFormatException e) {
                    System.out.println("Please type an integer!");
                    continue;
                }
                break;
            }
            if (encryptChoice <= 0) continue;
            System.out.print("Please enter the text to " + (encryptChoice == 1 ? "encrypt: " : "decrypt: "));
            String text = Console.getLine();
            System.out.print("Please type in a key: ");
            String key = Console.getLine();
            String output = "";
            if (encryptChoice == 1) {
                output = TranspositionCipher.encrypt(text, key);
                System.out.print("Encrypted ");
            } else if (encryptChoice == 2) {
                output = TranspositionCipher.decrypt(text, key);
                System.out.print("Decrypted ");
            }
            System.out.print("text:\n\n\"" + output + "\"\n\n");
        }
        System.out.println("Goodbye!");
    }

    public static String encrypt(String plaintext, String key) {
        String cipherText = "";
        plaintext = TranspositionCipher.padText(plaintext, key.length());
        ArrayList<String> cols = TranspositionCipher.convertPlaintextToColumns(plaintext, key.length());
        ArrayList<Integer> columnOrder = TranspositionCipher.getColumnOrder(key);
        for (int nextCol : columnOrder) {
            cipherText = String.valueOf(cipherText) + cols.get(nextCol);
        }
        return cipherText;
    }

    public static String decrypt(String ciphertext, String key) {
        String plaintext = "";
        try {
            if (ciphertext.length() % key.length() != 0) {
                IOException e = new IOException();
                throw e;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Ciphertext length is not divisible by key length!");
        }
        ArrayList<String> cols = TranspositionCipher.convertCiphertextToColumns(ciphertext, key.length());
        ArrayList<Integer> cipherColumnOrder = TranspositionCipher.getColumnOrder(key);
        ArrayList<String> originalCols = new ArrayList<String>();
        int keyLen = key.length();
        int i = 0;
        while (i < keyLen) {
            originalCols.add("");
            ++i;
        }
        i = 0;
        while (i < keyLen) {
            originalCols.set(cipherColumnOrder.get(i), cols.get(i));
            ++i;
        }
        int colSize = ciphertext.length() / keyLen;
        int i2 = 0;
        while (i2 < colSize) {
            int j = 0;
            while (j < keyLen) {
                plaintext = String.valueOf(plaintext) + ((String)originalCols.get(j)).charAt(i2);
                ++j;
            }
            ++i2;
        }
        plaintext = TranspositionCipher.removePadding(plaintext);
        return plaintext;
    }

    public static String padText(String text, int keyLen) {
        if (text.length() % keyLen != 0) {
            int padAmt = keyLen - text.length() % keyLen;
            int i = 0;
            while (i < padAmt) {
                text = String.valueOf(text) + PAD;
                ++i;
            }
        }
        return text;
    }

    public static String removePadding(String text) {
        while (text.charAt(text.length() - 1) == PAD) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static ArrayList<String> convertPlaintextToColumns(String text, int keyLen) {
        ArrayList<String> cols = new ArrayList<String>();
        int i = 0;
        while (i < keyLen) {
            cols.add("");
            ++i;
        }
        i = 0;
        while (i < text.length()) {
            cols.set(i % keyLen, String.valueOf(cols.get(i % keyLen)) + text.charAt(i));
            ++i;
        }
        return cols;
    }

    public static ArrayList<String> convertCiphertextToColumns(String text, int keyLen) {
        ArrayList<String> cols = new ArrayList<String>();
        int textSize = text.length();
        int colSize = textSize / keyLen;
        int i = 0;
        while (i < keyLen) {
            String col = "";
            int j = 0;
            while (j < colSize) {
                col = String.valueOf(col) + text.charAt(i * colSize + j);
                ++j;
            }
            cols.add(col);
            ++i;
        }
        return cols;
    }

    public static ArrayList<Integer> getColumnOrder(String key) {
        ArrayList<Integer> order = new ArrayList<Integer>();
        int keyLen = key.length();
        int col = 0;
        int i = 0;
        while (i < keyLen) {
            char min = '\u007f';
            int j = 0;
            while (j < keyLen) {
                if (key.charAt(j) < min) {
                    min = key.charAt(j);
                    col = j;
                }
                ++j;
            }
            key = String.valueOf(key.substring(0, col)) + '\u007f' + key.substring(col + 1, key.length());
            order.add(col);
            ++i;
        }
        return order;
    }
}

